package com.zehong.system.domain;

import java.util.Date;
import java.util.List;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 特殊作业单对象 t_special_document
 * 
 * @author zehong
 * @date 2023-12-04
 */
public class TSpecialDocument extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    private Long id;

    /** 申请部门id */
    private Long deptId;

    /** 申请人id */
    private Long userId;

    /** 作业证编号 */
    @Excel(name = "作业证编号")
    private String documentNum;

    /** 1动火作业证 2动土 3断路 4高处 5临时用电 6盲板 7受限空间 8吊装 */
    @Excel(name = "作业证类型",dictType = "t_special_permit_type")
    private Integer documentType;

    //申请部门
    @Excel(name = "申请部门")
    private String applyDeptName;

    //申请人
    @Excel(name = "申请人")
    private String applyName;

    /** 0待分析 1已过期 2待签字 3已完成 */
    @Excel(name = "状态",readConverterExp = "0=待分析,1=已过期,2=待签字,3=已完成")
    private Integer status;

    /** 开始时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "开始时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date startTime;

    /** 结束时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "结束时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date endTime;

    /** 基础信息json */
    private String baseJson;

    /** 分析json */
    private String analysisJson;

    /** 分析时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date analysisTime;

    /** 措施json */
    private String contentJson;

    private String signlist;

    private Integer sginNum;

    private Integer suspend;

    public Integer getSuspend() {
        return suspend;
    }

    public void setSuspend(Integer suspend) {
        this.suspend = suspend;
    }

    public Integer getSginNum() {
        return sginNum;
    }

    public void setSginNum(Integer sginNum) {
        this.sginNum = sginNum;
    }

    public String getSignlist() {
        return signlist;
    }

    public void setSignlist(String signlist) {
        this.signlist = signlist;
    }

    public void setId(Long id)
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }
    public void setDeptId(Long deptId) 
    {
        this.deptId = deptId;
    }

    public Long getDeptId() 
    {
        return deptId;
    }
    public void setUserId(Long userId) 
    {
        this.userId = userId;
    }

    public Long getUserId() 
    {
        return userId;
    }
    public void setDocumentType(Integer documentType) 
    {
        this.documentType = documentType;
    }

    public Integer getDocumentType() 
    {
        return documentType;
    }
    public void setDocumentNum(String documentNum) 
    {
        this.documentNum = documentNum;
    }

    public String getDocumentNum() 
    {
        return documentNum;
    }
    public void setStartTime(Date startTime) 
    {
        this.startTime = startTime;
    }

    public Date getStartTime() 
    {
        return startTime;
    }
    public void setEndTime(Date endTime) 
    {
        this.endTime = endTime;
    }

    public Date getEndTime() 
    {
        return endTime;
    }
    public void setBaseJson(String baseJson) 
    {
        this.baseJson = baseJson;
    }

    public String getBaseJson() 
    {
        return baseJson;
    }
    public void setAnalysisJson(String analysisJson) 
    {
        this.analysisJson = analysisJson;
    }

    public String getAnalysisJson() 
    {
        return analysisJson;
    }
    public void setAnalysisTime(Date analysisTime) 
    {
        this.analysisTime = analysisTime;
    }

    public Date getAnalysisTime() 
    {
        return analysisTime;
    }
    public void setContentJson(String contentJson) 
    {
        this.contentJson = contentJson;
    }

    public String getContentJson() 
    {
        return contentJson;
    }
    public void setStatus(Integer status) 
    {
        this.status = status;
    }

    public Integer getStatus() 
    {
        return status;
    }

    public String getApplyDeptName() {
        return applyDeptName;
    }

    public void setApplyDeptName(String applyDeptName) {
        this.applyDeptName = applyDeptName;
    }

    public String getApplyName() {
        return applyName;
    }

    public void setApplyName(String applyName) {
        this.applyName = applyName;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("deptId", getDeptId())
            .append("userId", getUserId())
            .append("documentType", getDocumentType())
            .append("documentNum", getDocumentNum())
            .append("startTime", getStartTime())
            .append("endTime", getEndTime())
            .append("baseJson", getBaseJson())
            .append("analysisJson", getAnalysisJson())
            .append("analysisTime", getAnalysisTime())
            .append("contentJson", getContentJson())
            .append("status", getStatus())
            .append("createTime", getCreateTime())
            .toString();
    }
}
