package com.zehong.system.domain;

import java.math.BigDecimal;
import java.util.List;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 管线打卡点对象 t_pipe_point
 * 
 * @author zehong
 * @date 2023-11-15
 */
public class TPipePoint extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    private Long id;

    /** 管线id */
    @Excel(name = "管线id")
    private Long pipeId;

    /** 打卡点名称 */
    @Excel(name = "打卡点名称")
    private String title;

    /** 经度 */
    @Excel(name = "经度")
    private BigDecimal longitude;

    /** 纬度 */
    @Excel(name = "纬度")
    private BigDecimal latitude;

    /** 上传照片，1必传，2选传 */
    @Excel(name = "上传照片",readConverterExp="1=必传,2=选传")
    private Integer hasImg;

    /** 创建人 */
    private Long adminId;

    @Excel(name = "创建人")
    private String adminName;
    //巡线人id
    private Long userId;

    private String pipeName;

    private String inspector;

    private List<TPipePoint> userPipeInfo;

    private List<TPipePoint> pipePointList;

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public void setId(Long id)
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }
    public void setPipeId(Long pipeId) 
    {
        this.pipeId = pipeId;
    }

    public Long getPipeId() 
    {
        return pipeId;
    }
    public void setTitle(String title) 
    {
        this.title = title;
    }

    public String getTitle() 
    {
        return title;
    }
    public void setLongitude(BigDecimal longitude) 
    {
        this.longitude = longitude;
    }

    public BigDecimal getLongitude() 
    {
        return longitude;
    }
    public void setLatitude(BigDecimal latitude) 
    {
        this.latitude = latitude;
    }

    public BigDecimal getLatitude() 
    {
        return latitude;
    }

    public Integer getHasImg() {
        return hasImg;
    }

    public void setHasImg(Integer hasImg) {
        this.hasImg = hasImg;
    }

    public void setAdminId(Long adminId)
    {
        this.adminId = adminId;
    }

    public Long getAdminId() 
    {
        return adminId;
    }

    public String getAdminName() {
        return adminName;
    }

    public void setAdminName(String adminName) {
        this.adminName = adminName;
    }

    public String getPipeName() {
        return pipeName;
    }

    public void setPipeName(String pipeName) {
        this.pipeName = pipeName;
    }

    public String getInspector() {
        return inspector;
    }

    public void setInspector(String inspector) {
        this.inspector = inspector;
    }

    public List<TPipePoint> getUserPipeInfo() {
        return userPipeInfo;
    }

    public void setUserPipeInfo(List<TPipePoint> userPipeInfo) {
        this.userPipeInfo = userPipeInfo;
    }

    public List<TPipePoint> getPipePointList() {
        return pipePointList;
    }

    public void setPipePointList(List<TPipePoint> pipePointList) {
        this.pipePointList = pipePointList;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("pipeId", getPipeId())
            .append("title", getTitle())
            .append("longitude", getLongitude())
            .append("latitude", getLatitude())
            .append("adminId", getAdminId())
            .append("createTime", getCreateTime())
            .toString();
    }
}
