package com.zehong.system.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 设备检验记录（生命全周期）对象 t_dev_inspect
 * 
 * @author zehong
 * @date 2023-12-15
 */
public class TDevInspect extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    private Long id;

    /** 设备主键 */
    @Excel(name = "设备主键")
    private Long devLifeId;

    /** 1检修2保养 */
    @Excel(name = "1检修2保养")
    private Long insType;

    /** 检验人姓名 */
    @Excel(name = "检验人姓名")
    private String insUname;

    /** 手机号 */
    @Excel(name = "手机号")
    private String insUphone;

    /** 内容描述 */
    @Excel(name = "内容描述")
    private String insContext;

    /** 本次日期 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "本次日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date currDate;

    /** 下次日期 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "下次日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date nextDate;

    /** 附件 */
    @Excel(name = "附件")
    private String fileUrl;

    /** 创建人 */
    @Excel(name = "创建人")
    private Long adminId;

    private String devType;

    public void setId(Long id) 
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }
    public void setDevLifeId(Long devLifeId) 
    {
        this.devLifeId = devLifeId;
    }

    public Long getDevLifeId() 
    {
        return devLifeId;
    }
    public void setInsType(Long insType) 
    {
        this.insType = insType;
    }

    public Long getInsType() 
    {
        return insType;
    }
    public void setInsUname(String insUname) 
    {
        this.insUname = insUname;
    }

    public String getInsUname() 
    {
        return insUname;
    }
    public void setInsUphone(String insUphone) 
    {
        this.insUphone = insUphone;
    }

    public String getInsUphone() 
    {
        return insUphone;
    }
    public void setInsContext(String insContext) 
    {
        this.insContext = insContext;
    }

    public String getInsContext() 
    {
        return insContext;
    }
    public void setCurrDate(Date currDate) 
    {
        this.currDate = currDate;
    }

    public Date getCurrDate() 
    {
        return currDate;
    }
    public void setNextDate(Date nextDate) 
    {
        this.nextDate = nextDate;
    }

    public Date getNextDate() 
    {
        return nextDate;
    }
    public void setFileUrl(String fileUrl) 
    {
        this.fileUrl = fileUrl;
    }

    public String getFileUrl() 
    {
        return fileUrl;
    }
    public void setAdminId(Long adminId) 
    {
        this.adminId = adminId;
    }

    public Long getAdminId() 
    {
        return adminId;
    }

    public String getDevType() {
        return devType;
    }

    public void setDevType(String devType) {
        this.devType = devType;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("devLifeId", getDevLifeId())
            .append("insType", getInsType())
            .append("insUname", getInsUname())
            .append("insUphone", getInsUphone())
            .append("insContext", getInsContext())
            .append("currDate", getCurrDate())
            .append("nextDate", getNextDate())
            .append("fileUrl", getFileUrl())
            .append("remark", getRemark())
            .append("adminId", getAdminId())
            .append("createTime", getCreateTime())
            .toString();
    }
}
