package com.zehong.web.controller.specialworkpermit;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TSpecialDocumentSign;
import com.zehong.system.service.ITSpecialDocumentSignService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 特殊作业单签字Controller
 * 
 * @author zehong
 * @date 2023-12-04
 */
@RestController
@RequestMapping("/workPermit/sign")
public class TSpecialDocumentSignController extends BaseController
{
    @Autowired
    private ITSpecialDocumentSignService tSpecialDocumentSignService;

    /**
     * 查询特殊作业单签字列表
     */
    //@PreAuthorize("@ss.hasPermi('workPermit:sign:list')")
    @GetMapping("/list")
    public TableDataInfo list(TSpecialDocumentSign tSpecialDocumentSign)
    {
        startPage();
        List<TSpecialDocumentSign> list = tSpecialDocumentSignService.selectTSpecialDocumentSignList(tSpecialDocumentSign);
        return getDataTable(list);
    }

    @GetMapping("/signInfoList")
    public AjaxResult signInfoList(TSpecialDocumentSign tSpecialDocumentSign){
        List<TSpecialDocumentSign> list = tSpecialDocumentSignService.selectTSpecialDocumentSignList(tSpecialDocumentSign);
        return AjaxResult.success(list);
    }

    /**
     * 导出特殊作业单签字列表
     */
    @PreAuthorize("@ss.hasPermi('workPermit:sign:export')")
    @Log(title = "特殊作业单签字", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TSpecialDocumentSign tSpecialDocumentSign)
    {
        List<TSpecialDocumentSign> list = tSpecialDocumentSignService.selectTSpecialDocumentSignList(tSpecialDocumentSign);
        ExcelUtil<TSpecialDocumentSign> util = new ExcelUtil<TSpecialDocumentSign>(TSpecialDocumentSign.class);
        return util.exportExcel(list, "特殊作业单签字数据");
    }

    /**
     * 获取特殊作业单签字详细信息
     */
    //@PreAuthorize("@ss.hasPermi('workPermit:sign:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(tSpecialDocumentSignService.selectTSpecialDocumentSignById(id));
    }

    /**
     * 新增特殊作业单签字
     */
    //@PreAuthorize("@ss.hasPermi('workPermit:sign:add')")
    @Log(title = "特殊作业单签字", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TSpecialDocumentSign tSpecialDocumentSign)
    {
        return toAjax(tSpecialDocumentSignService.insertTSpecialDocumentSign(tSpecialDocumentSign));
    }

    /**
     * 修改特殊作业单签字
     */
    //@PreAuthorize("@ss.hasPermi('workPermit:sign:edit')")
    @Log(title = "特殊作业单签字", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TSpecialDocumentSign tSpecialDocumentSign)
    {
        return toAjax(tSpecialDocumentSignService.updateTSpecialDocumentSign(tSpecialDocumentSign));
    }

    /**
     * 修改特殊作业单签字
     */
    //@PreAuthorize("@ss.hasPermi('workPermit:sign:edit')")
    @Log(title = "特殊作业单签字", businessType = BusinessType.UPDATE)
    @PutMapping("/updateSign")
    public AjaxResult updateSign(@RequestBody TSpecialDocumentSign tSpecialDocumentSign)
    {
        return toAjax(tSpecialDocumentSignService.updateSign(tSpecialDocumentSign));
    }

    /**
     * 删除特殊作业单签字
     */
    //@PreAuthorize("@ss.hasPermi('workPermit:sign:remove')")
    @Log(title = "特殊作业单签字", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(tSpecialDocumentSignService.deleteTSpecialDocumentSignByIds(ids));
    }
}
