package com.zehong.web.controller.devicemanage;

import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.core.page.TableDataInfo;
import com.zehong.common.enums.BusinessType;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.system.domain.TMapDot;
import com.zehong.system.service.ITMapDotService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 地图打点Controller
 * 
 * @author zehong
 * @date 2024-01-17
 */
@RestController
@RequestMapping("/device/mapDot")
public class TMapDotController extends BaseController
{
    @Autowired
    private ITMapDotService tMapDotService;

    /**
     * 查询地图打点列表
     */
    //@PreAuthorize("@ss.hasPermi('system:MapDot:list')")
    @GetMapping("/list")
    public TableDataInfo list(TMapDot tMapDot)
    {
        startPage();
        List<TMapDot> list = tMapDotService.selectTMapDotList(tMapDot);
        return getDataTable(list);
    }

    @GetMapping("/mapDotList")
    public AjaxResult mapDotList(TMapDot tMapDot){
        List<TMapDot> list = tMapDotService.selectTMapDotList(tMapDot);
        return AjaxResult.success(list);
    }

    /**
     * 导出地图打点列表
     */
   // @PreAuthorize("@ss.hasPermi('system:MapDot:export')")
    @Log(title = "地图打点", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TMapDot tMapDot)
    {
        List<TMapDot> list = tMapDotService.selectTMapDotList(tMapDot);
        ExcelUtil<TMapDot> util = new ExcelUtil<TMapDot>(TMapDot.class);
        return util.exportExcel(list, "地图打点数据");
    }

    /**
     * 获取地图打点详细信息
     */
   // @PreAuthorize("@ss.hasPermi('system:MapDot:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(tMapDotService.selectTMapDotById(id));
    }

    /**
     * 新增地图打点
     */
   // @PreAuthorize("@ss.hasPermi('system:MapDot:add')")
    @Log(title = "地图打点", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TMapDot tMapDot)
    {
        int code = tMapDotService.insertTMapDot(tMapDot);
        return code >0 ?AjaxResult.success(tMapDot) : AjaxResult.error();
    }

    /**
     * 修改地图打点
     */
   // @PreAuthorize("@ss.hasPermi('system:MapDot:edit')")
    @Log(title = "地图打点", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TMapDot tMapDot)
    {
        return toAjax(tMapDotService.updateTMapDot(tMapDot));
    }

    /**
     * 删除地图打点
     */
    //@PreAuthorize("@ss.hasPermi('system:MapDot:remove')")
    @Log(title = "地图打点", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(tMapDotService.deleteTMapDotByIds(ids));
    }
}
