package com.zehong.web.controller.baseinfo;

import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.core.page.TableDataInfo;
import com.zehong.common.enums.BusinessType;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.system.domain.TPipePoint;
import com.zehong.system.service.ITPipePointService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 管线打卡点Controller
 * 
 * @author zehong
 * @date 2023-11-15
 */
@RestController
@RequestMapping("/baseInfo/point")
public class TPipePointController extends BaseController
{
    @Autowired
    private ITPipePointService tPipePointService;

    /**
     * 查询管线打卡点列表
     */
    //@PreAuthorize("@ss.hasPermi('baseInfo:point:list')")
    @GetMapping("/list")
    public TableDataInfo list(TPipePoint tPipePoint)
    {
        startPage();
        List<TPipePoint> list = tPipePointService.selectTPipePointList(tPipePoint);
        return getDataTable(list);
    }

    @GetMapping("/pointInfoList")
    public AjaxResult pointInfoList(TPipePoint tPipePoint)
    {
        List<TPipePoint> list = tPipePointService.selectTPipePointList(tPipePoint);
        return AjaxResult.success(list);
    }
    /**
     * 导出管线打卡点列表
     */
    //@PreAuthorize("@ss.hasPermi('baseInfo:point:export')")
    @Log(title = "管线打卡点", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TPipePoint tPipePoint)
    {
        List<TPipePoint> list = tPipePointService.selectTPipePointList(tPipePoint);
        ExcelUtil<TPipePoint> util = new ExcelUtil<TPipePoint>(TPipePoint.class);
        return util.exportExcel(list, "管线打卡点数据");
    }

    /**
     * 获取管线打卡点详细信息
     */
    //@PreAuthorize("@ss.hasPermi('baseInfo:point:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(tPipePointService.selectTPipePointById(id));
    }

    /**
     * 新增管线打卡点
     */
    //@PreAuthorize("@ss.hasPermi('baseInfo:point:add')")
    @Log(title = "管线打卡点", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TPipePoint tPipePoint)
    {
        return toAjax(tPipePointService.insertTPipePoint(tPipePoint));
    }

    /**
     * 修改管线打卡点
     */
   // @PreAuthorize("@ss.hasPermi('baseInfo:point:edit')")
    @Log(title = "管线打卡点", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TPipePoint tPipePoint)
    {
        return toAjax(tPipePointService.updateTPipePoint(tPipePoint));
    }

    /**
     * 删除管线打卡点
     */
   // @PreAuthorize("@ss.hasPermi('baseInfo:point:remove')")
    @Log(title = "管线打卡点", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(tPipePointService.deleteTPipePointByIds(ids));
    }

    /**
     * 获取管线打卡点
     * @param pipeType 管线类型
     * @return
     */
    @GetMapping("/selectPointDetail")
    public AjaxResult selectPointDetail(@RequestParam(value = "pipeType") String pipeType){
        return AjaxResult.success(tPipePointService.selectPointDetail(pipeType));
    }
}
