package com.zehong.web.controller.baseinfo;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TPipeInfo;
import com.zehong.system.service.ITPipeInfoService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 管道信息Controller
 * 
 * @author zehong
 * @date 2023-11-02
 */
@RestController
@RequestMapping("/baseInfo/pipe")
public class TPipeInfoController extends BaseController
{
    @Autowired
    private ITPipeInfoService tPipeInfoService;

    /**
     * 查询管道信息列表
     */
    //@PreAuthorize("@ss.hasPermi('baseInfo:pipe:list')")
    @GetMapping("/list")
    public TableDataInfo list(TPipeInfo tPipeInfo)
    {
        startPage();
        List<TPipeInfo> list = tPipeInfoService.selectTPipeInfoList(tPipeInfo);
        return getDataTable(list);
    }


    @GetMapping("/pipeList")
    public AjaxResult pipeList(TPipeInfo tPipeInfo)
    {
        List<TPipeInfo> list = tPipeInfoService.selectTPipeInfoList(tPipeInfo);
        return AjaxResult.success(list);
    }

    /**
     * 导出管道信息列表
     */
    //@PreAuthorize("@ss.hasPermi('baseInfo:pipe:export')")
    @Log(title = "管道信息", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TPipeInfo tPipeInfo)
    {
        List<TPipeInfo> list = tPipeInfoService.selectTPipeInfoList(tPipeInfo);
        ExcelUtil<TPipeInfo> util = new ExcelUtil<TPipeInfo>(TPipeInfo.class);
        return util.exportExcel(list, "管道信息数据");
    }

    /**
     * 获取管道信息详细信息
     */
    //@PreAuthorize("@ss.hasPermi('baseInfo:pipe:query')")
    @GetMapping(value = "/{pipeId}")
    public AjaxResult getInfo(@PathVariable("pipeId") Long pipeId)
    {
        return AjaxResult.success(tPipeInfoService.selectTPipeInfoById(pipeId));
    }

    /**
     * 新增管道信息
     */
    //@PreAuthorize("@ss.hasPermi('baseInfo:pipe:add')")
    @Log(title = "管道信息", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TPipeInfo tPipeInfo)
    {
        return toAjax(tPipeInfoService.insertTPipeInfo(tPipeInfo));
    }

    /**
     * 修改管道信息
     */
    //@PreAuthorize("@ss.hasPermi('baseInfo:pipe:edit')")
    @Log(title = "管道信息", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TPipeInfo tPipeInfo)
    {
        return toAjax(tPipeInfoService.updateTPipeInfo(tPipeInfo));
    }

    /**
     * 删除管道信息
     */
    //@PreAuthorize("@ss.hasPermi('baseInfo:pipe:remove')")
    @Log(title = "管道信息", businessType = BusinessType.DELETE)
	@DeleteMapping("/{pipeIds}")
    public AjaxResult remove(@PathVariable Long[] pipeIds)
    {
        return toAjax(tPipeInfoService.deleteTPipeInfoByIds(pipeIds));
    }

    /**
     * 根据巡线查询管道信息
     * @param tPipeInfo 管道信息
     * @return
     */
    @GetMapping("/selectPipeInfoByUser")
    public AjaxResult selectPipeInfoByUser(TPipeInfo tPipeInfo){
        return AjaxResult.success(tPipeInfoService.selectPipeInfoByUser(tPipeInfo));
    }
}
