package com.zehong.system.service.impl;

import java.util.List;
import com.zehong.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TVideoManageMapper;
import com.zehong.system.domain.TVideoManage;
import com.zehong.system.service.ITVideoManageService;

/**
 * 视频管理Service业务层处理
 * 
 * @author zehong
 * @date 2024-03-28
 */
@Service
public class TVideoManageServiceImpl implements ITVideoManageService 
{
    @Autowired
    private TVideoManageMapper tVideoManageMapper;

    /**
     * 查询视频管理
     * 
     * @param videoId 视频管理ID
     * @return 视频管理
     */
    @Override
    public TVideoManage selectTVideoManageById(Long videoId)
    {
        return tVideoManageMapper.selectTVideoManageById(videoId);
    }

    /**
     * 查询视频管理列表
     * 
     * @param tVideoManage 视频管理
     * @return 视频管理
     */
    @Override
    public List<TVideoManage> selectTVideoManageList(TVideoManage tVideoManage)
    {
        return tVideoManageMapper.selectTVideoManageList(tVideoManage);
    }

    /**
     * 新增视频管理
     * 
     * @param tVideoManage 视频管理
     * @return 结果
     */
    @Override
    public int insertTVideoManage(TVideoManage tVideoManage)
    {
        tVideoManage.setCreateTime(DateUtils.getNowDate());
        return tVideoManageMapper.insertTVideoManage(tVideoManage);
    }

    /**
     * 修改视频管理
     * 
     * @param tVideoManage 视频管理
     * @return 结果
     */
    @Override
    public int updateTVideoManage(TVideoManage tVideoManage)
    {
        return tVideoManageMapper.updateTVideoManage(tVideoManage);
    }

    /**
     * 批量删除视频管理
     * 
     * @param videoIds 需要删除的视频管理ID
     * @return 结果
     */
    @Override
    public int deleteTVideoManageByIds(Long[] videoIds)
    {
        return tVideoManageMapper.deleteTVideoManageByIds(videoIds);
    }

    /**
     * 删除视频管理信息
     * 
     * @param videoId 视频管理ID
     * @return 结果
     */
    @Override
    public int deleteTVideoManageById(Long videoId)
    {
        return tVideoManageMapper.deleteTVideoManageById(videoId);
    }
}
