package com.zehong.system.service.impl;

import com.zehong.common.core.domain.entity.SysRole;
import com.zehong.common.utils.SecurityUtils;
import com.zehong.system.mapper.TScreenStatisticMapper;
import com.zehong.system.service.TScreenStatisticService;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 首页统计
 */
@Service
public class TScreenStatisticServiceImpl implements TScreenStatisticService{

    @Resource
    private TScreenStatisticMapper screenStatisticMapper;

    /**
     * 考勤打卡统计
     * @return
     */
    @Override
    public Map<String, Object> clockStatistic() {
        return screenStatisticMapper.clockStatistic();
    }

    /**
     * 最新任务统计
     * @param param 入参
     * @return
     */
    @Override
    public Map<String, Object> userCurrentTaskStatistic(Map<String, Object> param) {
        Map<String,Object> result = new HashMap<>();
        Map<String,Object> data = screenStatisticMapper.userCurrentTaskStatistic(param);
        if(data == null) return null;
        if(1 == (int)param.get("type") || 2 == (int)param.get("type")){
            result.put("title",data.get("title"));
            result.put("percent",Math.round(((Long) data.get("inspectNum")).doubleValue()/((Long) data.get("totalUserNum")).doubleValue()*100));
        }
        if(3 == (int)param.get("type")){
            result.put("title",data.get("title"));
            result.put("percent",Math.round(((Long) data.get("inspectNum")).doubleValue()/((Long) data.get("totalUserNum")).doubleValue()*100));
            result.put("totalUserNum",data.get("totalUserNum"));
            result.put("inspectNum",data.get("inspectNum"));
            result.put("noInspectNum",(Long)data.get("totalUserNum") - (Long)data.get("inspectNum"));
        }
        return result;
    }


    /**
     * 最新巡检统计
     * @param param 入参
     * @return
     */
    @Override
    public List<Map<String,Object>> userCurrentInspectStatistic(Map<String, Object> param) {
        List<Map<String,Object>> result = new ArrayList<>();
        List<Map<String,Object>> data = screenStatisticMapper.userCurrentInspectStatistic(param);
        if(data == null) return null;
        data.sort((o1, o2) -> {
            Long one = null;
            Long two = null;
            try {
                one = new SimpleDateFormat("yyyy-MM").parse(o1.get("dateTime").toString()).getTime();
                two = new SimpleDateFormat("yyyy-MM").parse(o2.get("dateTime").toString()).getTime();
            } catch (ParseException e) {
                e.printStackTrace();
            }
            one.compareTo(two);
            return one.compareTo(two);
        });

        data.stream().forEach(item ->{
            Map<String,Object> map = new HashMap<>();
            map.put("month",item.get("dateTime").toString().split("-")[1]);
            map.put("inspectNum",item.get("inspectNum"));
            result.add(map);
        });

        return result;
    }

    /**
     * 设备生命周期统计
     * @return
     */
    @Override
    public Map<String, Object> devLifeStatistic() {
        return screenStatisticMapper.devLifeStatistic();
    }

    @Override
    public Map<String, Object> dangerStatistic() {
        List<SysRole> roles = SecurityUtils.getLoginUser().getUser().getRoles();
        List<SysRole> visitor = roles.stream().filter(item ->"visitor".equals(item.getRoleKey())).collect(Collectors.toList());
        Map<String,Object> param = new HashMap<>();
        if(!CollectionUtils.isEmpty(visitor)){
            param.put("isVisitor","1");
        }
        return screenStatisticMapper.dangerStatistic(param);
    }
}
