package com.zehong.system.service;

import java.util.List;
import java.util.Map;

import com.zehong.system.domain.TPipeTaskInspect;

/**
 * 管线巡线任务执行Service接口
 * 
 * @author zehong
 * @date 2023-11-17
 */
public interface ITPipeTaskInspectService 
{
    /**
     * 查询管线巡线任务执行
     * 
     * @param id 管线巡线任务执行ID
     * @return 管线巡线任务执行
     */
    public TPipeTaskInspect selectTPipeTaskInspectById(Long id);

    /**
     * 查询管线巡线任务执行列表
     * 
     * @param tPipeTaskInspect 管线巡线任务执行
     * @return 管线巡线任务执行集合
     */
    public List<TPipeTaskInspect> selectTPipeTaskInspectList(TPipeTaskInspect tPipeTaskInspect);

    /**
     * 打卡点排序
     * @param tPipeTaskInspect
     * @return
     */
    public List<TPipeTaskInspect> selectPipeDistance(TPipeTaskInspect tPipeTaskInspect);


    /**
     * 新增管线巡线任务执行
     * 
     * @param tPipeTaskInspect 管线巡线任务执行
     * @return 结果
     */
    public int insertTPipeTaskInspect(TPipeTaskInspect tPipeTaskInspect);

    /**
     * 修改管线巡线任务执行
     * 
     * @param tPipeTaskInspect 管线巡线任务执行
     * @return 结果
     */
    public int updateTPipeTaskInspect(TPipeTaskInspect tPipeTaskInspect);

    /**
     * 批量删除管线巡线任务执行
     * 
     * @param ids 需要删除的管线巡线任务执行ID
     * @return 结果
     */
    public int deleteTPipeTaskInspectByIds(Long[] ids);

    /**
     * 删除管线巡线任务执行信息
     * 
     * @param id 管线巡线任务执行ID
     * @return 结果
     */
    public int deleteTPipeTaskInspectById(Long id);

    /**
     * 查询管线及打卡点信息
     * @param tPipeTaskInspect
     * @return
     */
    Map<String,Object> selectPipeAndPointInspectInfo(TPipeTaskInspect tPipeTaskInspect);

    int moreDailyInspect(TPipeTaskInspect tPipeTaskInspect);

    /**
     * 查询管线巡线任务打卡点执行列表
     *
     * @param tPipeTaskInspect 管线巡线任务执行
     * @return 管线巡线任务执行集合
     */
    List<TPipeTaskInspect> selectTPipeTaskPointInspectList(TPipeTaskInspect tPipeTaskInspect);
}
