package com.zehong.web.controller.urgentplan;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TUrgentContacts;
import com.zehong.system.service.ITUrgentContactsService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 应急联系人Controller
 * 
 * @author zehong
 * @date 2023-12-19
 */
@RestController
@RequestMapping("/urgent/contacts")
public class TUrgentContactsController extends BaseController
{
    @Autowired
    private ITUrgentContactsService tUrgentContactsService;

    /**
     * 查询应急联系人列表
     */
    //@PreAuthorize("@ss.hasPermi('urgent:contacts:list')")
    @GetMapping("/list")
    public TableDataInfo list(TUrgentContacts tUrgentContacts)
    {
        startPage();
        List<TUrgentContacts> list = tUrgentContactsService.selectTUrgentContactsList(tUrgentContacts);
        return getDataTable(list);
    }

    @GetMapping("/urgentContactsList")
    public AjaxResult urgentContactsList(TUrgentContacts tUrgentContacts)
    {
        List<TUrgentContacts> list = tUrgentContactsService.selectTUrgentContactsList(tUrgentContacts);
        return AjaxResult.success(list);
    }

    /**
     * 导出应急联系人列表
     */
    @PreAuthorize("@ss.hasPermi('urgent:contacts:export')")
    @Log(title = "应急联系人", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TUrgentContacts tUrgentContacts)
    {
        List<TUrgentContacts> list = tUrgentContactsService.selectTUrgentContactsList(tUrgentContacts);
        ExcelUtil<TUrgentContacts> util = new ExcelUtil<TUrgentContacts>(TUrgentContacts.class);
        return util.exportExcel(list, "应急联系人数据");
    }

    /**
     * 获取应急联系人详细信息
     */
    @PreAuthorize("@ss.hasPermi('urgent:contacts:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(tUrgentContactsService.selectTUrgentContactsById(id));
    }

    /**
     * 新增应急联系人
     */
    @PreAuthorize("@ss.hasPermi('urgent:contacts:add')")
    @Log(title = "应急联系人", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TUrgentContacts tUrgentContacts)
    {
        return toAjax(tUrgentContactsService.insertTUrgentContacts(tUrgentContacts));
    }

    /**
     * 修改应急联系人
     */
    @PreAuthorize("@ss.hasPermi('urgent:contacts:edit')")
    @Log(title = "应急联系人", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TUrgentContacts tUrgentContacts)
    {
        return toAjax(tUrgentContactsService.updateTUrgentContacts(tUrgentContacts));
    }

    /**
     * 删除应急联系人
     */
    @PreAuthorize("@ss.hasPermi('urgent:contacts:remove')")
    @Log(title = "应急联系人", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(tUrgentContactsService.deleteTUrgentContactsByIds(ids));
    }
}
