import request from '@/utils/request'

// 查询第三方施工执行列表
export function listInspect(query) {
  return request({
    url: '/third/inspect/list',
    method: 'get',
    params: query
  })
}

// 查询第三方施工执行详细
export function getInspect(id) {
  return request({
    url: '/third/inspect/' + id,
    method: 'get'
  })
}

// 新增第三方施工执行
export function addInspect(data) {
  return request({
    url: '/third/inspect',
    method: 'post',
    data: data
  })
}

// 修改第三方施工执行
export function updateInspect(data) {
  return request({
    url: '/third/inspect',
    method: 'put',
    data: data
  })
}

// 删除第三方施工执行
export function delInspect(id) {
  return request({
    url: '/third/inspect/' + id,
    method: 'delete'
  })
}

// 导出第三方施工执行
export function exportInspect(query) {
  return request({
    url: '/third/inspect/export',
    method: 'get',
    params: query
  })
}
