import request from '@/utils/request'

// 查询监测设备数据列表
export function listData(query) {
  return request({
    url: '/gas/data/list',
    method: 'get',
    params: query
  })
}

// 查询监测设备数据详细
export function getData(id) {
  return request({
    url: '/gas/data/' + id,
    method: 'get'
  })
}

// 新增监测设备数据
export function addData(data) {
  return request({
    url: '/gas/data',
    method: 'post',
    data: data
  })
}

// 修改监测设备数据
export function updateData(data) {
  return request({
    url: '/gas/data',
    method: 'put',
    data: data
  })
}

// 删除监测设备数据
export function delData(id) {
  return request({
    url: '/gas/data/' + id,
    method: 'delete'
  })
}

// 导出监测设备数据
export function exportData(query) {
  return request({
    url: '/gas/data/export',
    method: 'get',
    params: query
  })
}
