import request from '@/utils/request'

// 查询入户安检任务列表
export function listTask(query) {
  return request({
    url: '/checktask/task/list',
    method: 'get',
    params: query
  })
}

//所有任务信息
export function taskInfoList(query) {
  return request({
    url: '/checktask/task/taskInfoList',
    method: 'get',
    params: query
  })
}

// 查询入户安检任务详细
export function getTask(id) {
  return request({
    url: '/checktask/task/' + id,
    method: 'get'
  })
}

// 新增入户安检任务
export function addTask(data) {
  return request({
    url: '/checktask/task',
    method: 'post',
    data: data
  })
}

// 修改入户安检任务
export function updateTask(data) {
  return request({
    url: '/checktask/task',
    method: 'put',
    data: data
  })
}

// 删除入户安检任务
export function delTask(id) {
  return request({
    url: '/checktask/task/' + id,
    method: 'delete'
  })
}

// 导出入户安检任务
export function exportTask(query) {
  return request({
    url: '/checktask/task/export',
    method: 'get',
    params: query
  })
}

//任务详情 任务统计
export function taskDetailInfo(query) {
  return request({
    url: '/checktask/task/taskDetailInfo',
    method: 'get',
    params: query
  })
}

//任务详情任务进度统计
export function taskInspectDetailInfo(query) {
  return request({
    url: '/checktask/task/taskInspectDetailInfo',
    method: 'get',
    params: query
  })
}

//任务详情隐患统计
export function taskInspectDangerDetailInfo(query) {
  return request({
    url: '/checktask/task/taskInspectDangerDetailInfo',
    method: 'get',
    params: query
  })
}
