package com.zehong.system.service.impl;

import java.util.List;
import com.zehong.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TUrgentPlanMapper;
import com.zehong.system.domain.TUrgentPlan;
import com.zehong.system.service.ITUrgentPlanService;

/**
 * 应急预案Service业务层处理
 * 
 * @author zehong
 * @date 2023-12-19
 */
@Service
public class TUrgentPlanServiceImpl implements ITUrgentPlanService 
{
    @Autowired
    private TUrgentPlanMapper tUrgentPlanMapper;

    /**
     * 查询应急预案
     * 
     * @param id 应急预案ID
     * @return 应急预案
     */
    @Override
    public TUrgentPlan selectTUrgentPlanById(Long id)
    {
        return tUrgentPlanMapper.selectTUrgentPlanById(id);
    }

    /**
     * 查询应急预案列表
     * 
     * @param tUrgentPlan 应急预案
     * @return 应急预案
     */
    @Override
    public List<TUrgentPlan> selectTUrgentPlanList(TUrgentPlan tUrgentPlan)
    {
        return tUrgentPlanMapper.selectTUrgentPlanList(tUrgentPlan);
    }

    /**
     * 新增应急预案
     * 
     * @param tUrgentPlan 应急预案
     * @return 结果
     */
    @Override
    public int insertTUrgentPlan(TUrgentPlan tUrgentPlan)
    {
        tUrgentPlan.setCreateTime(DateUtils.getNowDate());
        return tUrgentPlanMapper.insertTUrgentPlan(tUrgentPlan);
    }

    /**
     * 修改应急预案
     * 
     * @param tUrgentPlan 应急预案
     * @return 结果
     */
    @Override
    public int updateTUrgentPlan(TUrgentPlan tUrgentPlan)
    {
        return tUrgentPlanMapper.updateTUrgentPlan(tUrgentPlan);
    }

    /**
     * 批量删除应急预案
     * 
     * @param ids 需要删除的应急预案ID
     * @return 结果
     */
    @Override
    public int deleteTUrgentPlanByIds(Long[] ids)
    {
        return tUrgentPlanMapper.deleteTUrgentPlanByIds(ids);
    }

    /**
     * 删除应急预案信息
     * 
     * @param id 应急预案ID
     * @return 结果
     */
    @Override
    public int deleteTUrgentPlanById(Long id)
    {
        return tUrgentPlanMapper.deleteTUrgentPlanById(id);
    }
}
