package com.zehong.system.service.impl;

import java.util.List;
import com.zehong.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TDeviceInfoMapper;
import com.zehong.system.domain.TDeviceInfo;
import com.zehong.system.service.ITDeviceInfoService;

/**
 * 设备信息Service业务层处理
 * 
 * @author zehong
 * @date 2023-11-01
 */
@Service
public class TDeviceInfoServiceImpl implements ITDeviceInfoService 
{
    @Autowired
    private TDeviceInfoMapper tDeviceInfoMapper;

    /**
     * 查询设备信息
     * 
     * @param deviceId 设备信息ID
     * @return 设备信息
     */
    @Override
    public TDeviceInfo selectTDeviceInfoById(Long deviceId)
    {
        return tDeviceInfoMapper.selectTDeviceInfoById(deviceId);
    }

    /**
     * 查询设备信息列表
     * 
     * @param tDeviceInfo 设备信息
     * @return 设备信息
     */
    @Override
    public List<TDeviceInfo> selectTDeviceInfoList(TDeviceInfo tDeviceInfo)
    {
        return tDeviceInfoMapper.selectTDeviceInfoList(tDeviceInfo);
    }

    /**
     * 新增设备信息
     * 
     * @param tDeviceInfo 设备信息
     * @return 结果
     */
    @Override
    public int insertTDeviceInfo(TDeviceInfo tDeviceInfo)
    {
        tDeviceInfo.setCreateTime(DateUtils.getNowDate());
        return tDeviceInfoMapper.insertTDeviceInfo(tDeviceInfo);
    }

    /**
     * 修改设备信息
     * 
     * @param tDeviceInfo 设备信息
     * @return 结果
     */
    @Override
    public int updateTDeviceInfo(TDeviceInfo tDeviceInfo)
    {
        tDeviceInfo.setUpdateTime(DateUtils.getNowDate());
        return tDeviceInfoMapper.updateTDeviceInfo(tDeviceInfo);
    }

    /**
     * 批量删除设备信息
     * 
     * @param deviceIds 需要删除的设备信息ID
     * @return 结果
     */
    @Override
    public int deleteTDeviceInfoByIds(Long[] deviceIds)
    {
        return tDeviceInfoMapper.deleteTDeviceInfoByIds(deviceIds);
    }

    /**
     * 删除设备信息信息
     * 
     * @param deviceId 设备信息ID
     * @return 结果
     */
    @Override
    public int deleteTDeviceInfoById(Long deviceId)
    {
        return tDeviceInfoMapper.deleteTDeviceInfoById(deviceId);
    }
}
