package com.zehong.system.service;

import java.util.List;
import java.util.Map;

import com.alibaba.fastjson.JSONObject;
import com.zehong.system.domain.TGasAlarm;

/**
 * 报警器报警记录Service接口
 * 
 * @author zehong
 * @date 2024-09-10
 */
public interface ITGasAlarmService 
{
    /**
     * 查询报警器报警记录
     * 
     * @param id 报警器报警记录ID
     * @return 报警器报警记录
     */
    public TGasAlarm selectTGasAlarmById(Long id);

    /**
     * 查询报警器报警记录列表
     * 
     * @param tGasAlarm 报警器报警记录
     * @return 报警器报警记录集合
     */
    public List<TGasAlarm> selectTGasAlarmList(TGasAlarm tGasAlarm);

    /**
     * 新增报警器报警记录
     * 
     * @param tGasAlarm 报警器报警记录
     * @return 结果
     */
    public int insertTGasAlarm(TGasAlarm tGasAlarm);

    /**
     * 修改报警器报警记录
     * 
     * @param tGasAlarm 报警器报警记录
     * @return 结果
     */
    public int updateTGasAlarm(TGasAlarm tGasAlarm);

    /**
     * 批量删除报警器报警记录
     * 
     * @param ids 需要删除的报警器报警记录ID
     * @return 结果
     */
    public int deleteTGasAlarmByIds(Long[] ids);

    /**
     * 删除报警器报警记录信息
     * 
     * @param id 报警器报警记录ID
     * @return 结果
     */
    public int deleteTGasAlarmById(Long id);

    /**
     * 获取缓存中报警信息
     * @return
     */
    List<JSONObject> getCacheAlarmInfo();
}
