package com.zehong.system.mapper;

import com.zehong.system.domain.TTaskInspect;
import com.zehong.system.domain.TTaskInspectExport;

import java.util.List;
import java.util.Map;

/**
 * 安检单导出Mapper接口
 * 
 * @author zehong
 * @date 2024-10-16
 */
public interface TTaskInspectExportMapper 
{
    /**
     * 查询安检单导出
     * 
     * @param exportId 安检单导出ID
     * @return 安检单导出
     */
    public TTaskInspectExport selectTTaskInspectExportById(Long exportId);

    /**
     * 查询安检单导出列表
     * 
     * @param tTaskInspectExport 安检单导出
     * @return 安检单导出集合
     */
    public List<TTaskInspectExport> selectTTaskInspectExportList(TTaskInspectExport tTaskInspectExport);

    /**
     * 新增安检单导出
     * 
     * @param tTaskInspectExport 安检单导出
     * @return 结果
     */
    public int insertTTaskInspectExport(TTaskInspectExport tTaskInspectExport);

    /**
     * 修改安检单导出
     * 
     * @param tTaskInspectExport 安检单导出
     * @return 结果
     */
    public int updateTTaskInspectExport(TTaskInspectExport tTaskInspectExport);

    /**
     * 删除安检单导出
     * 
     * @param exportId 安检单导出ID
     * @return 结果
     */
    public int deleteTTaskInspectExportById(Long exportId);

    /**
     * 批量删除安检单导出
     * 
     * @param exportIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTTaskInspectExportByIds(Long[] exportIds);

    /**
     * 获取每日安检单
     * @return
     */
    List<TTaskInspect> userInspectExport(Map<String,String> date);

    /**
     * 批量添加安检单
     * @param list
     * @return
     */
    int batchInsertInspectExport(List<TTaskInspectExport> list);

    /**
     * 文件名称
     * @param export
     * @return
     */
    List<String> selectFileNameList(TTaskInspectExport export);
}
