package com.zehong.system.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

import java.util.List;

/**
 * 人员分组信息对象 t_person_group_info
 * 
 * @author zehong
 * @date 2025-12-05
 */
public class TPersonGroupInfo extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long groupId;

    /** 组名 */
    @Excel(name = "组名")
    private String groupName;

    /** 是否删除(0正常，1删除) */
    @Excel(name = "是否删除",readConverterExp = "0=正常,1=删除")
    private String isDel;

    private String memberName;

    /** 备注 */
    @Excel(name = "备注")
    private String remarks;

    private List<TGroupMemberInfo> memberInfoList;

    public void setGroupId(Long groupId) 
    {
        this.groupId = groupId;
    }

    public Long getGroupId() 
    {
        return groupId;
    }
    public void setGroupName(String groupName) 
    {
        this.groupName = groupName;
    }

    public String getGroupName() 
    {
        return groupName;
    }
    public void setIsDel(String isDel) 
    {
        this.isDel = isDel;
    }

    public String getIsDel() 
    {
        return isDel;
    }
    public void setRemarks(String remarks) 
    {
        this.remarks = remarks;
    }

    public String getRemarks() 
    {
        return remarks;
    }

    public List<TGroupMemberInfo> getMemberInfoList() {
        return memberInfoList;
    }

    public void setMemberInfoList(List<TGroupMemberInfo> memberInfoList) {
        this.memberInfoList = memberInfoList;
    }

    public String getMemberName() {
        return memberName;
    }

    public void setMemberName(String memberName) {
        this.memberName = memberName;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("groupId", getGroupId())
            .append("groupName", getGroupName())
            .append("createBy", getCreateBy())
            .append("createTime", getCreateTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .append("isDel", getIsDel())
            .append("remarks", getRemarks())
            .toString();
    }
}
