package com.zehong.system.domain;

import java.math.BigDecimal;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 工业用户对象 t_industry
 * 
 * @author zehong
 * @date 2023-11-04
 */
public class TIndustry extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    private Long id;

    /** 用户编号 */
    @Excel(name = "用户编号")
    private String usernum;

    /** 统一社会信用代码 */
    @Excel(name = "统一社会信用代码")
    private String contract;

    /** 市 */
    @Excel(name = "市")
    private Long city;

    /** 区/县 */
    @Excel(name = "区/县")
    private Long county;

    /** 乡镇/街道 */
    @Excel(name = "乡镇/街道")
    private Long street;

    /** 村 */
    @Excel(name = "村")
    private Long village;

    /** 具体地址 */
    @Excel(name = "具体地址")
    private String address;

    /** 经度 */
    @Excel(name = "经度")
    private BigDecimal longitude;

    /** 纬度 */
    @Excel(name = "纬度")
    private BigDecimal latitude;

    /** 单位名称 */
    @Excel(name = "单位名称")
    private String company;

    /** 联系人姓名 */
    @Excel(name = "联系人姓名")
    private String username;

    /** 联系电话 */
    @Excel(name = "联系电话")
    private String phone;

    /** 用气场景（字典表） */
    @Excel(name = "用气场景", readConverterExp = "字=典表")
    private String type;

    /** 开通状态（字典表） */
    @Excel(name = "开通状态", readConverterExp = "字=典表")
    private String status;

    /** 通气日期 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "通气日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date starttime;

    /** 最新安检id */
    @Excel(name = "最新安检id")
    private Long taskInspectId;

    private String cityName;
    private String countyName;
    private String streetName;

    //巡检人
    private String inspector;

    //巡检状态
    private Integer inspectStatus;

    //满意度
    private Integer satisfy;

    //是否签字
    private Integer inspectSign;

    //最近巡检时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date inspectTime;

    //任务id
    private Long taskId;

    private String soutext;

    public String getSoutext() {
        return soutext;
    }

    public void setSoutext(String soutext) {
        this.soutext = soutext;
    }

    public String getCityName() {
        return cityName;
    }

    public void setCityName(String cityName) {
        this.cityName = cityName;
    }

    public String getCountyName() {
        return countyName;
    }

    public void setCountyName(String countyName) {
        this.countyName = countyName;
    }

    public String getStreetName() {
        return streetName;
    }

    public void setStreetName(String streetName) {
        this.streetName = streetName;
    }

    public Long getTaskInspectId() {
        return taskInspectId;
    }

    public void setTaskInspectId(Long taskInspectId) {
        this.taskInspectId = taskInspectId;
    }

    public void setId(Long id)
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }
    public void setUsernum(String usernum) 
    {
        this.usernum = usernum;
    }

    public String getUsernum() 
    {
        return usernum;
    }
    public void setContract(String contract) 
    {
        this.contract = contract;
    }

    public String getContract() 
    {
        return contract;
    }
    public void setCity(Long city) 
    {
        this.city = city;
    }

    public Long getCity() 
    {
        return city;
    }
    public void setCounty(Long county) 
    {
        this.county = county;
    }

    public Long getCounty() 
    {
        return county;
    }
    public void setStreet(Long street) 
    {
        this.street = street;
    }

    public Long getStreet() 
    {
        return street;
    }
    public void setVillage(Long village) 
    {
        this.village = village;
    }

    public Long getVillage() 
    {
        return village;
    }
    public void setAddress(String address) 
    {
        this.address = address;
    }

    public String getAddress() 
    {
        return address;
    }
    public void setLongitude(BigDecimal longitude) 
    {
        this.longitude = longitude;
    }

    public BigDecimal getLongitude() 
    {
        return longitude;
    }
    public void setLatitude(BigDecimal latitude) 
    {
        this.latitude = latitude;
    }

    public BigDecimal getLatitude() 
    {
        return latitude;
    }
    public void setCompany(String company) 
    {
        this.company = company;
    }

    public String getCompany() 
    {
        return company;
    }
    public void setUsername(String username) 
    {
        this.username = username;
    }

    public String getUsername() 
    {
        return username;
    }
    public void setPhone(String phone) 
    {
        this.phone = phone;
    }

    public String getPhone() 
    {
        return phone;
    }
    public void setType(String type) 
    {
        this.type = type;
    }

    public String getType() 
    {
        return type;
    }
    public void setStatus(String status) 
    {
        this.status = status;
    }

    public String getStatus() 
    {
        return status;
    }
    public void setStarttime(Date starttime) 
    {
        this.starttime = starttime;
    }

    public Date getStarttime() 
    {
        return starttime;
    }

    public String getInspector() {
        return inspector;
    }

    public void setInspector(String inspector) {
        this.inspector = inspector;
    }

    public Integer getInspectStatus() {
        return inspectStatus;
    }

    public void setInspectStatus(Integer inspectStatus) {
        this.inspectStatus = inspectStatus;
    }

    public Integer getSatisfy() {
        return satisfy;
    }

    public void setSatisfy(Integer satisfy) {
        this.satisfy = satisfy;
    }

    public Integer getInspectSign() {
        return inspectSign;
    }

    public void setInspectSign(Integer inspectSign) {
        this.inspectSign = inspectSign;
    }

    public Date getInspectTime() {
        return inspectTime;
    }

    public void setInspectTime(Date inspectTime) {
        this.inspectTime = inspectTime;
    }

    public Long getTaskId() {
        return taskId;
    }

    public void setTaskId(Long taskId) {
        this.taskId = taskId;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("usernum", getUsernum())
            .append("contract", getContract())
            .append("city", getCity())
            .append("county", getCounty())
            .append("street", getStreet())
            .append("village", getVillage())
            .append("address", getAddress())
            .append("longitude", getLongitude())
            .append("latitude", getLatitude())
            .append("company", getCompany())
            .append("username", getUsername())
            .append("phone", getPhone())
            .append("type", getType())
            .append("status", getStatus())
            .append("starttime", getStarttime())
            .append("task inspectId", getTaskInspectId())
            .append("remark", getRemark())
            .append("createTime", getCreateTime())
            .toString();
    }
}
