package com.zehong.system.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 设备巡检执行对象 t_device_inspect
 * 
 * @author zehong
 * @date 2023-11-30
 */
public class TDeviceInspect extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    @Excel(name = "设备名称")
    private String deviceName;

    @Excel(name = "地址")
    private String deviceAddr;

    private String iconUrl;

    @Excel(name = "联系人")
    private String linkman;

    @Excel(name = "联系电话")
    private String phone;

    /** id */
    private Long id;

    /** 设备id */
    private Long deviceId;

    /** 负责人id，巡检人id */
    private Long adminId;

    /** 检查单json */
    private String content;

    /** 是否有隐患，0没有，1有 */
    @Excel(name = "是否有隐患",readConverterExp = "0=否,1=是")
    private Integer danger;

    /** 下次巡检日期 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "下次巡检日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date nextTime;

    @Excel(name = "巡检人")
    private String inspector;

    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date inspectBeginTime;

    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date inspectEndTime;


    public void setId(Long id) 
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }
    public void setDeviceId(Long deviceId) 
    {
        this.deviceId = deviceId;
    }

    public Long getDeviceId() 
    {
        return deviceId;
    }
    public void setAdminId(Long adminId) 
    {
        this.adminId = adminId;
    }

    public Long getAdminId() 
    {
        return adminId;
    }
    public void setContent(String content) 
    {
        this.content = content;
    }

    public String getContent() 
    {
        return content;
    }
    public void setDanger(Integer danger) 
    {
        this.danger = danger;
    }

    public Integer getDanger() 
    {
        return danger;
    }
    public void setNextTime(Date nextTime) 
    {
        this.nextTime = nextTime;
    }

    public Date getNextTime() 
    {
        return nextTime;
    }

    public String getDeviceName() {
        return deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public String getDeviceAddr() {
        return deviceAddr;
    }

    public void setDeviceAddr(String deviceAddr) {
        this.deviceAddr = deviceAddr;
    }

    public String getIconUrl() {
        return iconUrl;
    }

    public void setIconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
    }

    public String getLinkman() {
        return linkman;
    }

    public void setLinkman(String linkman) {
        this.linkman = linkman;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getInspector() {
        return inspector;
    }

    public void setInspector(String inspector) {
        this.inspector = inspector;
    }

    public Date getInspectBeginTime() {
        return inspectBeginTime;
    }

    public void setInspectBeginTime(Date inspectBeginTime) {
        this.inspectBeginTime = inspectBeginTime;
    }

    public Date getInspectEndTime() {
        return inspectEndTime;
    }

    public void setInspectEndTime(Date inspectEndTime) {
        this.inspectEndTime = inspectEndTime;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("deviceId", getDeviceId())
            .append("adminId", getAdminId())
            .append("content", getContent())
            .append("danger", getDanger())
            .append("createTime", getCreateTime())
            .append("nextTime", getNextTime())
            .toString();
    }
}
