package com.zehong.system.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

import java.util.List;

/**
 * 隐患日常巡检记录对象 t_danger_inspect_record_info
 * 
 * @author zehong
 * @date 2024-12-17
 */
public class TDangerInspectRecordInfo extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long id;

    /** 巡检名称 */
    @Excel(name = "巡检名称")
    private String inspectName;

    /** 巡检内容 */
    @Excel(name = "巡检内容")
    private String inspectContent;

    /** 巡检人 */
    @Excel(name = "巡检人")
    private Long inspector;

    /** 是否有隐患: 0无 1有 */
    @Excel(name = "是否有隐患: 0无 1有")
    private String hasDanger;

    private String inspectorName;

    private List<Long> dangerId;

    public void setId(Long id) 
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }
    public void setInspectName(String inspectName) 
    {
        this.inspectName = inspectName;
    }

    public String getInspectName() 
    {
        return inspectName;
    }
    public void setInspectContent(String inspectContent)
    {
        this.inspectContent = inspectContent;
    }

    public String getInspectContent()
    {
        return inspectContent;
    }
    public void setInspector(Long inspector) 
    {
        this.inspector = inspector;
    }

    public Long getInspector() 
    {
        return inspector;
    }

    public String getInspectorName() {
        return inspectorName;
    }

    public void setInspectorName(String inspectorName) {
        this.inspectorName = inspectorName;
    }

    public List<Long> getDangerId() {
        return dangerId;
    }

    public void setDangerId(List<Long> dangerId) {
        this.dangerId = dangerId;
    }

    public String getHasDanger() {
        return hasDanger;
    }

    public void setHasDanger(String hasDanger) {
        this.hasDanger = hasDanger;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("inspectName", getInspectName())
            .append("inspectContent", getInspectContent())
            .append("inspector", getInspector())
            .append("createTime", getCreateTime())
            .toString();
    }
}
