package com.zehong.web.controller.video;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TVideoManage;
import com.zehong.system.service.ITVideoManageService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 视频管理Controller
 * 
 * @author zehong
 * @date 2024-03-28
 */
@RestController
@RequestMapping("/video/manage")
public class TVideoManageController extends BaseController
{
    @Autowired
    private ITVideoManageService tVideoManageService;

    /**
     * 查询视频管理列表
     */
    @PreAuthorize("@ss.hasPermi('video:manage:list')")
    @GetMapping("/list")
    public TableDataInfo list(TVideoManage tVideoManage)
    {
        startPage();
        List<TVideoManage> list = tVideoManageService.selectTVideoManageList(tVideoManage);
        return getDataTable(list);
    }

    @GetMapping("/videoInfoList")
    public AjaxResult videoInfoList(TVideoManage tVideoManage){
        List<TVideoManage> list = tVideoManageService.selectTVideoManageList(tVideoManage);
        return AjaxResult.success(list);
    }

    /**
     * 导出视频管理列表
     */
    @PreAuthorize("@ss.hasPermi('video:manage:export')")
    @Log(title = "视频管理", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TVideoManage tVideoManage)
    {
        List<TVideoManage> list = tVideoManageService.selectTVideoManageList(tVideoManage);
        ExcelUtil<TVideoManage> util = new ExcelUtil<TVideoManage>(TVideoManage.class);
        return util.exportExcel(list, "视频管理数据");
    }

    /**
     * 获取视频管理详细信息
     */
    @PreAuthorize("@ss.hasPermi('video:manage:query')")
    @GetMapping(value = "/{videoId}")
    public AjaxResult getInfo(@PathVariable("videoId") Long videoId)
    {
        return AjaxResult.success(tVideoManageService.selectTVideoManageById(videoId));
    }

    /**
     * 新增视频管理
     */
    @PreAuthorize("@ss.hasPermi('video:manage:add')")
    @Log(title = "视频管理", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TVideoManage tVideoManage)
    {
        return toAjax(tVideoManageService.insertTVideoManage(tVideoManage));
    }

    /**
     * 修改视频管理
     */
    @PreAuthorize("@ss.hasPermi('video:manage:edit')")
    @Log(title = "视频管理", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TVideoManage tVideoManage)
    {
        return toAjax(tVideoManageService.updateTVideoManage(tVideoManage));
    }

    /**
     * 删除视频管理
     */
    @PreAuthorize("@ss.hasPermi('video:manage:remove')")
    @Log(title = "视频管理", businessType = BusinessType.DELETE)
	@DeleteMapping("/{videoIds}")
    public AjaxResult remove(@PathVariable Long[] videoIds)
    {
        return toAjax(tVideoManageService.deleteTVideoManageByIds(videoIds));
    }
}
