package com.zehong.web.controller.devicemanage;

import java.util.List;

import com.zehong.common.core.domain.model.LoginUser;
import com.zehong.common.utils.ServletUtils;
import com.zehong.framework.web.service.TokenService;
import com.zehong.system.domain.TDeviceInfo;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.core.page.TableDataInfo;
import com.zehong.common.enums.BusinessType;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.system.domain.TDeviceTaskInspect;
import com.zehong.system.service.ITDeviceTaskInspectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 设备巡检执行Controller
 * 
 * @author zehong
 * @date 2023-12-11
 */
@RestController
@RequestMapping("/device/inspect")
public class TDeviceTaskInspectController extends BaseController
{
    @Autowired
    private ITDeviceTaskInspectService tDeviceTaskInspectService;
    @Autowired
    private TokenService tokenService;

    /**
     * 查询设备巡检执行列表
     */
    //@PreAuthorize("@ss.hasPermi('device:inspect:list')")
    @GetMapping("/list")
    public TableDataInfo list(TDeviceTaskInspect tDeviceTaskInspect)
    {
        startPage();
        List<TDeviceTaskInspect> list = tDeviceTaskInspectService.selectTDeviceTaskInspectList(tDeviceTaskInspect);
        return getDataTable(list);
    }

    /**
     * 设备检测情况列表
     * @param tDeviceTaskInspect
     * @return
     */
    @GetMapping("/deviceInspectList")
    public TableDataInfo deviceInspectList(TDeviceInfo tDeviceInfo)
    {
        startPage();
        List<TDeviceInfo> list = tDeviceTaskInspectService.deviceInspectList(tDeviceInfo);
        return getDataTable(list);
    }
    /**
     * 导出设备巡检执行列表
     */
    //@PreAuthorize("@ss.hasPermi('device:inspect:export')")
    @Log(title = "设备巡检执行", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TDeviceTaskInspect tDeviceTaskInspect)
    {
        List<TDeviceTaskInspect> list = tDeviceTaskInspectService.selectTDeviceTaskInspectList(tDeviceTaskInspect);
        ExcelUtil<TDeviceTaskInspect> util = new ExcelUtil<TDeviceTaskInspect>(TDeviceTaskInspect.class);
        return util.exportExcel(list, "设备巡检执行数据");
    }

    /**
     * 获取设备巡检执行详细信息
     */
    //@PreAuthorize("@ss.hasPermi('device:inspect:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(tDeviceTaskInspectService.selectTDeviceTaskInspectById(id));
    }

    /**
     * 新增设备巡检执行
     */
    //@PreAuthorize("@ss.hasPermi('device:inspect:add')")
    @Log(title = "设备巡检执行", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TDeviceTaskInspect tDeviceTaskInspect)
    {
        LoginUser loginUser = tokenService.getLoginUser(ServletUtils.getRequest());
        Long userId = loginUser.getUser().getUserId();
        tDeviceTaskInspect.setAdminId(userId);
        return toAjax(tDeviceTaskInspectService.insertTDeviceTaskInspect(tDeviceTaskInspect));
    }

    /**
     * 修改设备巡检执行
     */
    //@PreAuthorize("@ss.hasPermi('device:inspect:edit')")
    @Log(title = "设备巡检执行", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TDeviceTaskInspect tDeviceTaskInspect)
    {
        return toAjax(tDeviceTaskInspectService.updateTDeviceTaskInspect(tDeviceTaskInspect));
    }

    /**
     * 删除设备巡检执行
     */
    //@PreAuthorize("@ss.hasPermi('device:inspect:remove')")
    @Log(title = "设备巡检执行", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(tDeviceTaskInspectService.deleteTDeviceTaskInspectByIds(ids));
    }

    /**
     * 设备巡检信息
     * @param tDeviceTaskInspect 巡检实体
     * @return
     */
    @GetMapping("/selectTDeviceTaskInspectInfoList")
    public TableDataInfo selectTDeviceTaskInspectInfoList(TDeviceTaskInspect tDeviceTaskInspect){
        startPage();
        return getDataTable(tDeviceTaskInspectService.selectTDeviceTaskInspectInfoList(tDeviceTaskInspect));
    }
}
