package com.zehong.web.controller.book;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TFailure;
import com.zehong.system.service.ITFailureService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 事故台账Controller
 * 
 * @author zehong
 * @date 2023-12-20
 */
@RestController
@RequestMapping("/book/failure")
public class TFailureController extends BaseController
{
    @Autowired
    private ITFailureService tFailureService;

    /**
     * 查询事故台账列表
     */
    //@PreAuthorize("@ss.hasPermi('book:failure:list')")
    @GetMapping("/list")
    public TableDataInfo list(TFailure tFailure)
    {
        startPage();
        List<TFailure> list = tFailureService.selectTFailureList(tFailure);
        return getDataTable(list);
    }

    /**
     * 导出事故台账列表
     */
    @PreAuthorize("@ss.hasPermi('book:failure:export')")
    @Log(title = "事故台账", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TFailure tFailure)
    {
        List<TFailure> list = tFailureService.selectTFailureList(tFailure);
        ExcelUtil<TFailure> util = new ExcelUtil<TFailure>(TFailure.class);
        return util.exportExcel(list, "事故台账数据");
    }

    /**
     * 获取事故台账详细信息
     */
    //@PreAuthorize("@ss.hasPermi('book:failure:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(tFailureService.selectTFailureById(id));
    }

    /**
     * 新增事故台账
     */
    @PreAuthorize("@ss.hasPermi('book:failure:add')")
    @Log(title = "事故台账", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TFailure tFailure)
    {
        return toAjax(tFailureService.insertTFailure(tFailure));
    }

    /**
     * 修改事故台账
     */
    @PreAuthorize("@ss.hasPermi('book:failure:edit')")
    @Log(title = "事故台账", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TFailure tFailure)
    {
        return toAjax(tFailureService.updateTFailure(tFailure));
    }

    /**
     * 删除事故台账
     */
    @PreAuthorize("@ss.hasPermi('book:failure:remove')")
    @Log(title = "事故台账", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(tFailureService.deleteTFailureByIds(ids));
    }
}
