package com.zehong.web.controller.baseinfo;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TDeviceInfo;
import com.zehong.system.service.ITDeviceInfoService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 设备信息Controller
 * 
 * @author zehong
 * @date 2023-11-01
 */
@RestController
@RequestMapping("/baseInfo/device")
public class TDeviceInfoController extends BaseController
{
    @Autowired
    private ITDeviceInfoService tDeviceInfoService;

    /**
     * 查询设备信息列表
     */
    @PreAuthorize("@ss.hasPermi('baseInfo:device:list')")
    @GetMapping("/list")
    public TableDataInfo list(TDeviceInfo tDeviceInfo)
    {
        startPage();
        List<TDeviceInfo> list = tDeviceInfoService.selectTDeviceInfoList(tDeviceInfo);
        return getDataTable(list);
    }

    @GetMapping("/deviceInfoList")
    public AjaxResult deviceInfoList(TDeviceInfo tDeviceInfo){
        List<TDeviceInfo> list = tDeviceInfoService.selectTDeviceInfoList(tDeviceInfo);
        return AjaxResult.success(list);
    }

    /**
     * 导出设备信息列表
     */
    @PreAuthorize("@ss.hasPermi('baseInfo:device:export')")
    @Log(title = "设备信息", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TDeviceInfo tDeviceInfo)
    {
        List<TDeviceInfo> list = tDeviceInfoService.selectTDeviceInfoList(tDeviceInfo);
        ExcelUtil<TDeviceInfo> util = new ExcelUtil<TDeviceInfo>(TDeviceInfo.class);
        return util.exportExcel(list, "设备信息数据");
    }

    /**
     * 获取设备信息详细信息
     */
    @PreAuthorize("@ss.hasPermi('baseInfo:device:query')")
    @GetMapping(value = "/{deviceId}")
    public AjaxResult getInfo(@PathVariable("deviceId") Long deviceId)
    {
        return AjaxResult.success(tDeviceInfoService.selectTDeviceInfoById(deviceId));
    }

    /**
     * 新增设备信息
     */
    @PreAuthorize("@ss.hasPermi('baseInfo:device:add')")
    @Log(title = "设备信息", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TDeviceInfo tDeviceInfo)
    {
        return toAjax(tDeviceInfoService.insertTDeviceInfo(tDeviceInfo));
    }

    /**
     * 修改设备信息
     */
    @PreAuthorize("@ss.hasPermi('baseInfo:device:edit')")
    @Log(title = "设备信息", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TDeviceInfo tDeviceInfo)
    {
        return toAjax(tDeviceInfoService.updateTDeviceInfo(tDeviceInfo));
    }

    /**
     * 删除设备信息
     */
    @PreAuthorize("@ss.hasPermi('baseInfo:device:remove')")
    @Log(title = "设备信息", businessType = BusinessType.DELETE)
	@DeleteMapping("/{deviceIds}")
    public AjaxResult remove(@PathVariable Long[] deviceIds)
    {
        return toAjax(tDeviceInfoService.deleteTDeviceInfoByIds(deviceIds));
    }
}
