import request from '@/utils/request'

// 新增设备检验记录（生命全周期）
export function addInspect(data) {
  return request({
    url: '/system/cycle/inspect',
    method: 'post',
    data: data
  })
}
// 查询设备检验记录（生命全周期）列表
export function listInspect(query) {
  return request({
    url: '/system/cycle/inspect/list',
    method: 'get',
    params: query
  })
}
// 查询【请填写功能名称】列表
export function listCycle(query) {
  return request({
    url: '/system/cycle/list',
    method: 'get',
    params: query
  })
}

// 检修页查询列表
export function listCycleByParam(query) {
  return request({
    url: '/system/cycle/listByParam',
    method: 'get',
    params: query
  })
}

// 临检设备查询
export function closeInspectDevice(query) {
  return request({
    url: '/system/cycle/closeInspectDevice',
    method: 'get',
    params: query
  })
}

// 查询【请填写功能名称】详细
export function getCycle(id) {
  return request({
    url: '/system/cycle/' + id,
    method: 'get'
  })
}

// 新增【请填写功能名称】
export function addCycle(data) {
  return request({
    url: '/system/cycle',
    method: 'post',
    data: data
  })
}

// 修改【请填写功能名称】
export function updateCycle(data) {
  return request({
    url: '/system/cycle',
    method: 'put',
    data: data
  })
}

// 删除【请填写功能名称】
export function delCycle(id) {
  return request({
    url: '/system/cycle/' + id,
    method: 'delete'
  })
}

// 导出【请填写功能名称】
export function exportCycle(query) {
  return request({
    url: '/system/cycle/export',
    method: 'get',
    params: query
  })
}

//设备类型统计
export function devLifeStatistic(query) {
  return request({
    url: '/system/cycle/devLifeStatistic',
    method: 'get',
    params: query
  })
}

//批量新增检验记录
export function batchAddInspect(data) {
  return request({
    url: '/system/cycle/batchAddInspect',
    method: 'post',
    data: data
  })
}
