package com.zehong.system.service.impl;

import java.util.List;
import com.zehong.common.utils.DateUtils;
import com.zehong.common.utils.SecurityUtils;
import com.zehong.system.domain.TDanger;
import com.zehong.system.mapper.TDangerMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TDangerInspectRecordInfoMapper;
import com.zehong.system.domain.TDangerInspectRecordInfo;
import com.zehong.system.service.ITDangerInspectRecordInfoService;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;

/**
 * 隐患日常巡检记录Service业务层处理
 * 
 * @author zehong
 * @date 2024-12-17
 */
@Service
public class TDangerInspectRecordInfoServiceImpl implements ITDangerInspectRecordInfoService 
{
    @Autowired
    private TDangerInspectRecordInfoMapper tDangerInspectRecordInfoMapper;

    @Resource
    private TDangerMapper tDangerMapper;

    /**
     * 查询隐患日常巡检记录
     * 
     * @param id 隐患日常巡检记录ID
     * @return 隐患日常巡检记录
     */
    @Override
    public TDangerInspectRecordInfo selectTDangerInspectRecordInfoById(Long id)
    {
        return tDangerInspectRecordInfoMapper.selectTDangerInspectRecordInfoById(id);
    }

    /**
     * 查询隐患日常巡检记录列表
     * 
     * @param tDangerInspectRecordInfo 隐患日常巡检记录
     * @return 隐患日常巡检记录
     */
    @Override
    public List<TDangerInspectRecordInfo> selectTDangerInspectRecordInfoList(TDangerInspectRecordInfo tDangerInspectRecordInfo)
    {
        return tDangerInspectRecordInfoMapper.selectTDangerInspectRecordInfoList(tDangerInspectRecordInfo);
    }

    /**
     * 新增隐患日常巡检记录
     * 
     * @param tDangerInspectRecordInfo 隐患日常巡检记录
     * @return 结果
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public int insertTDangerInspectRecordInfo(TDangerInspectRecordInfo tDangerInspectRecordInfo)
    {
        tDangerInspectRecordInfo.setCreateTime(DateUtils.getNowDate());
        tDangerInspectRecordInfo.setInspector(SecurityUtils.getLoginUser().getUser().getUserId());
        tDangerInspectRecordInfo.setHasDanger(CollectionUtils.isEmpty(tDangerInspectRecordInfo.getDangerId()) ? "0" : "1");
        int result = tDangerInspectRecordInfoMapper.insertTDangerInspectRecordInfo(tDangerInspectRecordInfo);
        if(!CollectionUtils.isEmpty(tDangerInspectRecordInfo.getDangerId())){
            for(Long dangerId : tDangerInspectRecordInfo.getDangerId()){
                TDanger danger = new TDanger();
                danger.setId(dangerId);
                danger.setInspectId(tDangerInspectRecordInfo.getId());
                danger.setStatus(0);
                tDangerMapper.updateTDanger(danger);
            }
        }
        return result;
    }

    /**
     * 修改隐患日常巡检记录
     * 
     * @param tDangerInspectRecordInfo 隐患日常巡检记录
     * @return 结果
     */
    @Override
    public int updateTDangerInspectRecordInfo(TDangerInspectRecordInfo tDangerInspectRecordInfo)
    {
        return tDangerInspectRecordInfoMapper.updateTDangerInspectRecordInfo(tDangerInspectRecordInfo);
    }

    /**
     * 批量删除隐患日常巡检记录
     * 
     * @param ids 需要删除的隐患日常巡检记录ID
     * @return 结果
     */
    @Override
    public int deleteTDangerInspectRecordInfoByIds(Long[] ids)
    {
        return tDangerInspectRecordInfoMapper.deleteTDangerInspectRecordInfoByIds(ids);
    }

    /**
     * 删除隐患日常巡检记录信息
     * 
     * @param id 隐患日常巡检记录ID
     * @return 结果
     */
    @Override
    public int deleteTDangerInspectRecordInfoById(Long id)
    {
        return tDangerInspectRecordInfoMapper.deleteTDangerInspectRecordInfoById(id);
    }
}
