package com.zehong.system.domain;

import java.math.BigDecimal;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 安检隐患整改对象 t_danger
 * 
 * @author zehong
 * @date 2023-11-09
 */
public class TDanger extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    private Long id;

    /** 任务id */
    private Long taskId;

    /** 任务执行id */
    private Long inspectId;

    /** 居民，工商户，工业id */
    private Long receiveId;

    /** 隐患标题 */
    @Excel(name = "隐患标题")
    private String title;

    /** 隐患类型，1是居民用户安检，2是餐饮用户安检，3是工业用户安检，4是巡线安检，5是场站安检，6是调压箱安检，7是其他 */
    @Excel(name = "隐患类型",readConverterExp = "1=居民用户安检,2=餐饮用户安检,3=工业用户安检,4=巡线安检,5=场站安检,6=调压箱安检,7=其他")
    private Long type;

    /** 隐患类型，1是隐患，2是故障 */
    @Excel(name = "隐患类型",readConverterExp="1=隐患,2=故障")
    private Integer category;

    @Excel(name = "用户")
    private String receiveName;

    /** 隐患级别，1一般，2重大 */
    @Excel(name = "隐患级别",readConverterExp = "1=重大,2=一般")
    private Integer level;

    /** 隐患内容 */
    @Excel(name = "隐患内容")
    private String beforeContent;

    /** 联系电话 */
    @Excel(name = "联系电话")
    private String phone;

    /** 具体地址 */
    @Excel(name = "具体地址")
    private String address;

    /** 经度 */
    @Excel(name = "经度")
    private BigDecimal longitude;

    /** 纬度 */
    @Excel(name = "纬度")
    private BigDecimal latitude;

    /** 隐患整改前图片 */
    @Excel(name = "隐患整改前图片")
    private String beforeImg;

    /** 隐患整改前视频 */
    @Excel(name = "隐患整改前视频")
    private String beforeVideo;

    /** 隐患责任人，1是用户自己，2是公司客服部 */
    @Excel(name = "责任归属",readConverterExp = "1=安全管理部,2=客服运营部,3=生产运营部")
    private Integer flag;

    /** 整改内容 */
    @Excel(name = "整改内容")
    private String afterContent;

    private Integer reformId;

    @Excel(name = "整改人")
    private String reformName;

    /** 隐患整改后图片 */
    @Excel(name = "隐患整改后图片")
    private String afterImg;

    /** 整改时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "整改时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date reformTime;

    /** 整改开始时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "整改开始时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date startTime;

    /** 整改结束时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "整改结束时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date endTime;

    /** 整改方式 */
    @Excel(name = "整改方式",readConverterExp = "1=用户自行整改，2=用户出资公司整改，3=通知厂家上门维修检查，4=公司出资整改")
    private String dealMethod;

    /** 隐患状态，0待处理，1待复核，2已处理 */
    @Excel(name = "隐患状态",readConverterExp = "0=待处理,1=拒绝整改,2=待复核,3=已处理,4=已归档")
    private Integer status;

    private Integer adminId;

    private Integer finish;

    private String reportName;

    /** 复核人 */
    private Long checkId;

    /** 复核时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date checkTime;

    /** 复核备注 */
    private String checkRemark;

    private String checkName;

    /** 复核照片 */
    @Excel(name = "复核照片")
    private String checkImg;

    /**归档人id*/
    private Long fileId;

    /**归档人姓名*/
    private String fileName;

    /** 归档时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date fileTime;

    private String adminName;

    /** 是否为游客: 0否 1是 */
    private String isVisitor;

    /** 治理的标准要求 */
    @Excel(name = "治理的标准要求")
    private String governanceStandards;

    /** 治理方法 */
    @Excel(name = "治理方法")
    private String governanceMethod;

    /** 经费和物资的落实 */
    @Excel(name = "经费和物资的落实")
    private String fundsMaterials;

    /** 安全措施和应急预案 */
    @Excel(name = "安全措施和应急预案")
    private String safetyEmergencyPlan;

    private TTaskInspect tTaskInspect;

    public void setId(Long id)
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }
    public void setTaskId(Long taskId) 
    {
        this.taskId = taskId;
    }

    public Long getTaskId() 
    {
        return taskId;
    }
    public void setInspectId(Long inspectId) 
    {
        this.inspectId = inspectId;
    }

    public Long getInspectId() 
    {
        return inspectId;
    }
    public void setType(Long type) 
    {
        this.type = type;
    }

    public Long getType() 
    {
        return type;
    }
    public void setReceiveId(Long receiveId) 
    {
        this.receiveId = receiveId;
    }

    public Integer getCategory() {
        return category;
    }

    public void setCategory(Integer category) {
        this.category = category;
    }

    public Long getReceiveId()
    {
        return receiveId;
    }
    public void setTitle(String title) 
    {
        this.title = title;
    }

    public String getTitle() 
    {
        return title;
    }
    public void setLevel(Integer level) 
    {
        this.level = level;
    }

    public Integer getLevel() 
    {
        return level;
    }
    public void setBeforeContent(String beforeContent) 
    {
        this.beforeContent = beforeContent;
    }

    public String getBeforeContent() 
    {
        return beforeContent;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public void setAddress(String address)
    {
        this.address = address;
    }

    public String getAddress() 
    {
        return address;
    }
    public void setLongitude(BigDecimal longitude) 
    {
        this.longitude = longitude;
    }

    public BigDecimal getLongitude() 
    {
        return longitude;
    }
    public void setLatitude(BigDecimal latitude) 
    {
        this.latitude = latitude;
    }

    public BigDecimal getLatitude() 
    {
        return latitude;
    }
    public void setBeforeImg(String beforeImg) 
    {
        this.beforeImg = beforeImg;
    }

    public String getBeforeImg() 
    {
        return beforeImg;
    }
    public void setBeforeVideo(String beforeVideo) 
    {
        this.beforeVideo = beforeVideo;
    }

    public String getBeforeVideo() 
    {
        return beforeVideo;
    }
    public void setFlag(Integer flag) 
    {
        this.flag = flag;
    }

    public Integer getFlag() 
    {
        return flag;
    }
    public void setAfterContent(String afterContent) 
    {
        this.afterContent = afterContent;
    }

    public String getAfterContent() 
    {
        return afterContent;
    }
    public void setAfterImg(String afterImg) 
    {
        this.afterImg = afterImg;
    }

    public Integer getReformId() {
        return reformId;
    }

    public void setReformId(Integer reformId) {
        this.reformId = reformId;
    }

    public String getReformName() {
        return reformName;
    }

    public void setReformName(String reformName) {
        this.reformName = reformName;
    }

    public String getAfterImg()
    {
        return afterImg;
    }
    public void setStartTime(Date startTime) 
    {
        this.startTime = startTime;
    }

    public Date getStartTime() 
    {
        return startTime;
    }
    public void setEndTime(Date endTime) 
    {
        this.endTime = endTime;
    }

    public Date getEndTime() 
    {
        return endTime;
    }
    public void setStatus(Integer status) 
    {
        this.status = status;
    }

    public Integer getStatus() 
    {
        return status;
    }

    public String getReceiveName() {
        return receiveName;
    }

    public void setReceiveName(String receiveName) {
        this.receiveName = receiveName;
    }

    public Integer getAdminId() {
        return adminId;
    }

    public void setAdminId(Integer adminId) {
        this.adminId = adminId;
    }

    public Integer getFinish() {
        return finish;
    }

    public void setFinish(Integer finish) {
        this.finish = finish;
    }

    public String getReportName() {
        return reportName;
    }

    public void setReportName(String reportName) {
        this.reportName = reportName;
    }

    public Date getReformTime() {
        return reformTime;
    }

    public void setReformTime(Date reformTime) {
        this.reformTime = reformTime;
    }

    public Long getCheckId() {
        return checkId;
    }

    public void setCheckId(Long checkId) {
        this.checkId = checkId;
    }

    public Date getCheckTime() {
        return checkTime;
    }

    public void setCheckTime(Date checkTime) {
        this.checkTime = checkTime;
    }

    public String getCheckRemark() {
        return checkRemark;
    }

    public void setCheckRemark(String checkRemark) {
        this.checkRemark = checkRemark;
    }

    public String getCheckName() {
        return checkName;
    }

    public void setCheckName(String checkName) {
        this.checkName = checkName;
    }

    public Long getFileId() {
        return fileId;
    }

    public void setFileId(Long fileId) {
        this.fileId = fileId;
    }

    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public Date getFileTime() {
        return fileTime;
    }

    public void setFileTime(Date fileTime) {
        this.fileTime = fileTime;
    }

    public String getAdminName() {
        return adminName;
    }

    public void setAdminName(String adminName) {
        this.adminName = adminName;
    }

    public String getCheckImg() {
        return checkImg;
    }

    public void setCheckImg(String checkImg) {
        this.checkImg = checkImg;
    }

    public String getIsVisitor() {
        return isVisitor;
    }

    public void setIsVisitor(String isVisitor) {
        this.isVisitor = isVisitor;
    }

    public String getGovernanceStandards() {
        return governanceStandards;
    }

    public void setGovernanceStandards(String governanceStandards) {
        this.governanceStandards = governanceStandards;
    }

    public String getGovernanceMethod() {
        return governanceMethod;
    }

    public void setGovernanceMethod(String governanceMethod) {
        this.governanceMethod = governanceMethod;
    }

    public String getFundsMaterials() {
        return fundsMaterials;
    }

    public void setFundsMaterials(String fundsMaterials) {
        this.fundsMaterials = fundsMaterials;
    }

    public String getSafetyEmergencyPlan() {
        return safetyEmergencyPlan;
    }

    public void setSafetyEmergencyPlan(String safetyEmergencyPlan) {
        this.safetyEmergencyPlan = safetyEmergencyPlan;
    }

    public TTaskInspect gettTaskInspect() {
        return tTaskInspect;
    }

    public void settTaskInspect(TTaskInspect tTaskInspect) {
        this.tTaskInspect = tTaskInspect;
    }

    public String getDealMethod() {
        return dealMethod;
    }

    public void setDealMethod(String dealMethod) {
        this.dealMethod = dealMethod;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("taskId", getTaskId())
            .append("inspectId", getInspectId())
            .append("type", getType())
            .append("receiveId", getReceiveId())
            .append("title", getTitle())
            .append("level", getLevel())
            .append("beforeContent", getBeforeContent())
            .append("address", getAddress())
            .append("longitude", getLongitude())
            .append("latitude", getLatitude())
            .append("beforeImg", getBeforeImg())
            .append("beforeVideo", getBeforeVideo())
            .append("flag", getFlag())
            .append("afterContent", getAfterContent())
            .append("afterImg", getAfterImg())
            .append("startTime", getStartTime())
            .append("endTime", getEndTime())
            .append("status", getStatus())
            .append("createTime", getCreateTime())
            .append("remark", getRemark())
            .toString();
    }
}
