package com.zehong.web.controller.baseinfo;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TCommunity;
import com.zehong.system.service.ITCommunityService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 居民小区（村）Controller
 * 
 * @author zehong
 * @date 2023-11-03
 */
@RestController
@RequestMapping("/system/community")
public class TCommunityController extends BaseController
{
    @Autowired
    private ITCommunityService tCommunityService;

    /**
     * 查询居民小区（村）列表
     */
    //@PreAuthorize("@ss.hasPermi('system:community:list')")
    @GetMapping("/list")
    public TableDataInfo list(TCommunity tCommunity)
    {
        startPage();
        List<TCommunity> list = tCommunityService.selectTCommunityList(tCommunity);
        return getDataTable(list);
    }


    /**
     * 小区列表
     * @param tCommunity 小区实体
     * @return
     */
    @GetMapping("/communityList")
    public AjaxResult communityList(TCommunity tCommunity){
        List<TCommunity> list = tCommunityService.selectTCommunityList(tCommunity);
        return AjaxResult.success(list);
    }

    /**
     * 导出居民小区（村）列表
     */
    //@PreAuthorize("@ss.hasPermi('system:community:export')")
    @Log(title = "居民小区（村）", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TCommunity tCommunity)
    {
        List<TCommunity> list = tCommunityService.selectTCommunityList(tCommunity);
        ExcelUtil<TCommunity> util = new ExcelUtil<TCommunity>(TCommunity.class);
        return util.exportExcel(list, "居民小区（村）数据");
    }

    /**
     * 获取居民小区（村）详细信息
     */
    //@PreAuthorize("@ss.hasPermi('system:community:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(tCommunityService.selectTCommunityById(id));
    }

    /**
     * 新增居民小区（村）
     */
    //@PreAuthorize("@ss.hasPermi('system:community:add')")
    @Log(title = "居民小区（村）", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TCommunity tCommunity)
    {
        return toAjax(tCommunityService.insertTCommunity(tCommunity));
    }

    /**
     * 修改居民小区（村）
     */
    //@PreAuthorize("@ss.hasPermi('system:community:edit')")
    @Log(title = "居民小区（村）", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TCommunity tCommunity)
    {
        return toAjax(tCommunityService.updateTCommunity(tCommunity));
    }

    /**
     * 删除居民小区（村）
     */
    //@PreAuthorize("@ss.hasPermi('system:community:remove')")
    @Log(title = "居民小区（村）", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(tCommunityService.deleteTCommunityByIds(ids));
    }
}
