package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TEmergencyAlarmRelationInfo;

/**
 * 应急报警关联关系Mapper接口
 * 
 * @author zehong
 * @date 2024-12-09
 */
public interface TEmergencyAlarmRelationInfoMapper 
{
    /**
     * 查询应急报警关联关系
     * 
     * @param id 应急报警关联关系ID
     * @return 应急报警关联关系
     */
    public TEmergencyAlarmRelationInfo selectTEmergencyAlarmRelationInfoById(Long id);

    /**
     * 查询应急报警关联关系列表
     * 
     * @param tEmergencyAlarmRelationInfo 应急报警关联关系
     * @return 应急报警关联关系集合
     */
    public List<TEmergencyAlarmRelationInfo> selectTEmergencyAlarmRelationInfoList(TEmergencyAlarmRelationInfo tEmergencyAlarmRelationInfo);

    /**
     * 新增应急报警关联关系
     * 
     * @param tEmergencyAlarmRelationInfo 应急报警关联关系
     * @return 结果
     */
    public int insertTEmergencyAlarmRelationInfo(TEmergencyAlarmRelationInfo tEmergencyAlarmRelationInfo);

    /**
     * 修改应急报警关联关系
     * 
     * @param tEmergencyAlarmRelationInfo 应急报警关联关系
     * @return 结果
     */
    public int updateTEmergencyAlarmRelationInfo(TEmergencyAlarmRelationInfo tEmergencyAlarmRelationInfo);

    /**
     * 删除应急报警关联关系
     * 
     * @param id 应急报警关联关系ID
     * @return 结果
     */
    public int deleteTEmergencyAlarmRelationInfoById(Long id);


    int deleteTEmergencyAlarmRelationInfoByAlarmId(Long alarmId);

    /**
     * 批量删除应急报警关联关系
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    public int deleteTEmergencyAlarmRelationInfoByIds(Long[] ids);
}
