package com.zehong.web.controller.devicemanage;

import java.util.List;

import com.zehong.common.core.domain.model.LoginUser;
import com.zehong.common.utils.ServletUtils;
import com.zehong.framework.web.service.TokenService;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TSiteTaskInspect;
import com.zehong.system.service.ITSiteTaskInspectService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 场站巡检执行Controller
 * 
 * @author zehong
 * @date 2023-12-15
 */
@RestController
@RequestMapping("/site/inspect")
public class TSiteTaskInspectController extends BaseController
{
    @Autowired
    private ITSiteTaskInspectService tSiteTaskInspectService;

    @Autowired
    private TokenService tokenService;
    /**
     * 查询场站巡检执行列表
     */
   // @PreAuthorize("@ss.hasPermi('site:inspect:list')")
    @GetMapping("/list")
    public TableDataInfo list(TSiteTaskInspect tSiteTaskInspect)
    {
        startPage();
        List<TSiteTaskInspect> list = tSiteTaskInspectService.selectTSiteTaskInspectList(tSiteTaskInspect);
        return getDataTable(list);
    }

    /**
     * 导出场站巡检执行列表
     */
    //@PreAuthorize("@ss.hasPermi('site:inspect:export')")
    @Log(title = "场站巡检执行", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TSiteTaskInspect tSiteTaskInspect)
    {
        List<TSiteTaskInspect> list = tSiteTaskInspectService.selectTSiteTaskInspectList(tSiteTaskInspect);
        ExcelUtil<TSiteTaskInspect> util = new ExcelUtil<TSiteTaskInspect>(TSiteTaskInspect.class);
        return util.exportExcel(list, "场站巡检执行数据");
    }

    /**
     * 获取场站巡检执行详细信息
     */
   // @PreAuthorize("@ss.hasPermi('site:inspect:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(tSiteTaskInspectService.selectTSiteTaskInspectById(id));
    }

    /**
     * 新增场站巡检执行
     */
    //@PreAuthorize("@ss.hasPermi('site:inspect:add')")
    @Log(title = "场站巡检执行", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TSiteTaskInspect tSiteTaskInspect)
    {
        LoginUser loginUser = tokenService.getLoginUser(ServletUtils.getRequest());
        Long userId = loginUser.getUser().getUserId();
        tSiteTaskInspect.setAdminId(userId);
        return toAjax(tSiteTaskInspectService.insertTSiteTaskInspect(tSiteTaskInspect));
    }

    /**
     * 修改场站巡检执行
     */
    //@PreAuthorize("@ss.hasPermi('site:inspect:edit')")
    @Log(title = "场站巡检执行", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TSiteTaskInspect tSiteTaskInspect)
    {
        return toAjax(tSiteTaskInspectService.updateTSiteTaskInspect(tSiteTaskInspect));
    }

    /**
     * 删除场站巡检执行
     */
    //@PreAuthorize("@ss.hasPermi('site:inspect:remove')")
    @Log(title = "场站巡检执行", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(tSiteTaskInspectService.deleteTSiteTaskInspectByIds(ids));
    }

    /**
     * 场站巡检记录
     * @param tSiteTaskInspect 巡检实体
     * @return
     */
    @GetMapping("/selectSiteStationInspectInfo")
    public TableDataInfo selectSiteStationInspectInfo(TSiteTaskInspect tSiteTaskInspect){
        startPage();
        return getDataTable(tSiteTaskInspectService.selectSiteStationInspectInfo(tSiteTaskInspect));
    }
}
