package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TPersonGroupInfo;

/**
 * 人员分组信息Service接口
 * 
 * @author zehong
 * @date 2025-12-05
 */
public interface ITPersonGroupInfoService 
{
    /**
     * 查询人员分组信息
     * 
     * @param groupId 人员分组信息ID
     * @return 人员分组信息
     */
    public TPersonGroupInfo selectTPersonGroupInfoById(Long groupId);

    /**
     * 查询人员分组信息列表
     * 
     * @param tPersonGroupInfo 人员分组信息
     * @return 人员分组信息集合
     */
    public List<TPersonGroupInfo> selectTPersonGroupInfoList(TPersonGroupInfo tPersonGroupInfo);

    /**
     * 新增人员分组信息
     * 
     * @param tPersonGroupInfo 人员分组信息
     * @return 结果
     */
    public int insertTPersonGroupInfo(TPersonGroupInfo tPersonGroupInfo);

    /**
     * 修改人员分组信息
     * 
     * @param tPersonGroupInfo 人员分组信息
     * @return 结果
     */
    public int updateTPersonGroupInfo(TPersonGroupInfo tPersonGroupInfo);

    /**
     * 批量删除人员分组信息
     * 
     * @param groupIds 需要删除的人员分组信息ID
     * @return 结果
     */
    public int deleteTPersonGroupInfoByIds(Long[] groupIds);

    /**
     * 删除人员分组信息信息
     * 
     * @param groupId 人员分组信息ID
     * @return 结果
     */
    public int deleteTPersonGroupInfoById(Long groupId);
}
