package com.zehong.system.domain;

import java.math.BigDecimal;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 管线巡线任务执行对象 t_pipe_task_inspect
 * 
 * @author zehong
 * @date 2023-11-17
 */
public class TPipeTaskInspect extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    private Long id;

    /** 巡线任务id */
    @Excel(name = "巡线任务id")
    private Long taskId;

    /** 巡线员id */
    @Excel(name = "巡线员id")
    private Long userId;

    /** 打卡点id */
    @Excel(name = "打卡点id")
    private Long point;

    /** 打卡点经度 */
    @Excel(name = "打卡点经度")
    private BigDecimal longitude;

    /** 打卡点纬度 */
    @Excel(name = "打卡点纬度")
    private BigDecimal latitude;

    /** 打卡状态，0未打卡，1已打卡 */
    @Excel(name = "打卡状态，0未打卡，1已打卡")
    private Integer status;

    @Excel(name = "上传图片")
    private String imgurl;

    /** 巡检单内容 */
    @Excel(name = "巡检单内容")
    private String content;

    /** 是否有隐患，0没有，1有 */
    @Excel(name = "是否有隐患",readConverterExp = "0=没有，1=有")
    private Integer danger;

    private String pipeName;

    private String pointTitle;

    private String inspector;

    private Long pipeId;

    private BigDecimal distance;

    private String title;

    private BigDecimal pointLongitude;

    private BigDecimal pointLatitude;

    private Integer hasImg;

    public Integer getHasImg() {
        return hasImg;
    }

    public void setHasImg(Integer hasImg) {
        this.hasImg = hasImg;
    }

    public String getImgurl() {
        return imgurl;
    }

    public void setImgurl(String imgurl) {
        this.imgurl = imgurl;
    }

    public BigDecimal getDistance() {
        return distance;
    }

    public void setDistance(BigDecimal distance) {
        this.distance = distance;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setId(Long id)
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }
    public void setTaskId(Long taskId) 
    {
        this.taskId = taskId;
    }

    public Long getTaskId() 
    {
        return taskId;
    }
    public void setUserId(Long userId) 
    {
        this.userId = userId;
    }

    public Long getUserId() 
    {
        return userId;
    }
    public void setPoint(Long point) 
    {
        this.point = point;
    }

    public Long getPoint() 
    {
        return point;
    }
    public void setLongitude(BigDecimal longitude) 
    {
        this.longitude = longitude;
    }

    public BigDecimal getLongitude() 
    {
        return longitude;
    }
    public void setLatitude(BigDecimal latitude) 
    {
        this.latitude = latitude;
    }

    public BigDecimal getLatitude() 
    {
        return latitude;
    }
    public void setStatus(Integer status) 
    {
        this.status = status;
    }

    public Integer getStatus() 
    {
        return status;
    }
    public void setContent(String content) 
    {
        this.content = content;
    }

    public String getContent() 
    {
        return content;
    }

    public Integer getDanger() {
        return danger;
    }

    public void setDanger(Integer danger) {
        this.danger = danger;
    }

    public String getPipeName() {
        return pipeName;
    }

    public void setPipeName(String pipeName) {
        this.pipeName = pipeName;
    }

    public String getPointTitle() {
        return pointTitle;
    }

    public void setPointTitle(String pointTitle) {
        this.pointTitle = pointTitle;
    }

    public String getInspector() {
        return inspector;
    }

    public void setInspector(String inspector) {
        this.inspector = inspector;
    }

    public Long getPipeId() {
        return pipeId;
    }

    public void setPipeId(Long pipeId) {
        this.pipeId = pipeId;
    }

    public BigDecimal getPointLongitude() {
        return pointLongitude;
    }

    public void setPointLongitude(BigDecimal pointLongitude) {
        this.pointLongitude = pointLongitude;
    }

    public BigDecimal getPointLatitude() {
        return pointLatitude;
    }

    public void setPointLatitude(BigDecimal pointLatitude) {
        this.pointLatitude = pointLatitude;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("taskId", getTaskId())
            .append("userId", getUserId())
            .append("point", getPoint())
            .append("longitude", getLongitude())
            .append("latitude", getLatitude())
            .append("status", getStatus())
            .append("createTime", getCreateTime())
            .append("content", getContent())
            .toString();
    }
}
