package com.zehong.system.service.impl;

import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TClockInMapper;
import com.zehong.system.domain.TClockIn;
import com.zehong.system.service.ITClockInService;

/**
 * 考勤打卡Service业务层处理
 * 
 * @author zehong
 * @date 2023-11-15
 */
@Service
public class TClockInServiceImpl implements ITClockInService 
{
    @Autowired
    private TClockInMapper tClockInMapper;

    /**
     * 查询考勤打卡
     * 
     * @param id 考勤打卡ID
     * @return 考勤打卡
     */
    @Override
    public TClockIn selectTClockInById(Long id)
    {
        return tClockInMapper.selectTClockInById(id);
    }

    /**
     * 查询考勤打卡列表
     * 
     * @param tClockIn 考勤打卡
     * @return 考勤打卡
     */
    @Override
    public List<TClockIn> selectTClockInList(TClockIn tClockIn)
    {
        return tClockInMapper.selectTClockInList(tClockIn);
    }

    /**
     * 新增考勤打卡
     * 
     * @param tClockIn 考勤打卡
     * @return 结果
     */
    @Override
    public int insertTClockIn(TClockIn tClockIn)
    {
        tClockIn.setClockTime(new Date());
        return tClockInMapper.insertTClockIn(tClockIn);
    }

    /**
     * 修改考勤打卡
     * 
     * @param tClockIn 考勤打卡
     * @return 结果
     */
    @Override
    public int updateTClockIn(TClockIn tClockIn)
    {
        return tClockInMapper.updateTClockIn(tClockIn);
    }

    /**
     * 批量删除考勤打卡
     * 
     * @param ids 需要删除的考勤打卡ID
     * @return 结果
     */
    @Override
    public int deleteTClockInByIds(Long[] ids)
    {
        return tClockInMapper.deleteTClockInByIds(ids);
    }

    /**
     * 删除考勤打卡信息
     * 
     * @param id 考勤打卡ID
     * @return 结果
     */
    @Override
    public int deleteTClockInById(Long id)
    {
        return tClockInMapper.deleteTClockInById(id);
    }
}
