package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TPipeTaskUser;

/**
 * 管线巡检起止Service接口
 * 
 * @author zehong
 * @date 2023-11-17
 */
public interface ITPipeTaskUserService 
{
    /**
     * 查询管线巡检起止
     * 
     * @param id 管线巡检起止ID
     * @return 管线巡检起止
     */
    public TPipeTaskUser selectTPipeTaskUserById(Long id);

    /**
     * 查询管线巡检起止列表
     * 
     * @param tPipeTaskUser 管线巡检起止
     * @return 管线巡检起止集合
     */
    public List<TPipeTaskUser> selectTPipeTaskUserList(TPipeTaskUser tPipeTaskUser);

    /**
     * 新增管线巡检起止
     * 
     * @param tPipeTaskUser 管线巡检起止
     * @return 结果
     */
    public int insertTPipeTaskUser(TPipeTaskUser tPipeTaskUser);

    /**
     * 开始结束巡检
     * @param tPipeTaskUser
     * @return
     */
    public int updateStatus(TPipeTaskUser tPipeTaskUser);

    /**
     * 修改管线巡检起止
     * 
     * @param tPipeTaskUser 管线巡检起止
     * @return 结果
     */
    public int updateTPipeTaskUser(TPipeTaskUser tPipeTaskUser);

    /**
     * 批量删除管线巡检起止
     * 
     * @param ids 需要删除的管线巡检起止ID
     * @return 结果
     */
    public int deleteTPipeTaskUserByIds(Long[] ids);

    /**
     * 删除管线巡检起止信息
     * 
     * @param id 管线巡检起止ID
     * @return 结果
     */
    public int deleteTPipeTaskUserById(Long id);
}
