package com.zehong.system.service;

import java.util.List;
import java.util.Map;

import com.zehong.system.domain.TGroupMemberInfo;

/**
 * 组内成员信息Service接口
 * 
 * @author zehong
 * @date 2025-12-05
 */
public interface ITGroupMemberInfoService 
{
    /**
     * 查询组内成员信息
     * 
     * @param memberId 组内成员信息ID
     * @return 组内成员信息
     */
    public TGroupMemberInfo selectTGroupMemberInfoById(Long memberId);

    /**
     * 查询组内成员信息列表
     * 
     * @param tGroupMemberInfo 组内成员信息
     * @return 组内成员信息集合
     */
    public List<TGroupMemberInfo> selectTGroupMemberInfoList(TGroupMemberInfo tGroupMemberInfo);

    /**
     * 新增组内成员信息
     * 
     * @param tGroupMemberInfo 组内成员信息
     * @return 结果
     */
    public int insertTGroupMemberInfo(TGroupMemberInfo tGroupMemberInfo);

    /**
     * 修改组内成员信息
     * 
     * @param tGroupMemberInfo 组内成员信息
     * @return 结果
     */
    public int updateTGroupMemberInfo(TGroupMemberInfo tGroupMemberInfo);

    /**
     * 批量删除组内成员信息
     * 
     * @param memberIds 需要删除的组内成员信息ID
     * @return 结果
     */
    public int deleteTGroupMemberInfoByIds(Long[] memberIds);

    /**
     * 删除组内成员信息信息
     * 
     * @param memberId 组内成员信息ID
     * @return 结果
     */
    public int deleteTGroupMemberInfoById(Long memberId);

    /**
     * 获取人员信息
     * @return
     */
    List<Map<String,Object>> selectMemberInfo(Map<String,Object> map);
}
