package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TEmergencyResponse;

/**
 * 应急响应Service接口
 * 
 * @author zehong
 * @date 2024-09-06
 */
public interface ITEmergencyResponseService 
{
    /**
     * 查询应急响应
     * 
     * @param responseId 应急响应ID
     * @return 应急响应
     */
    public TEmergencyResponse selectTEmergencyResponseById(Long responseId);

    /**
     * 查询应急响应列表
     * 
     * @param tEmergencyResponse 应急响应
     * @return 应急响应集合
     */
    public List<TEmergencyResponse> selectTEmergencyResponseList(TEmergencyResponse tEmergencyResponse);

    /**
     * 新增应急响应
     * 
     * @param tEmergencyResponse 应急响应
     * @return 结果
     */
    public int insertTEmergencyResponse(TEmergencyResponse tEmergencyResponse);

    /**
     * 修改应急响应
     * 
     * @param tEmergencyResponse 应急响应
     * @return 结果
     */
    public int updateTEmergencyResponse(TEmergencyResponse tEmergencyResponse);

    /**
     * 批量删除应急响应
     * 
     * @param responseIds 需要删除的应急响应ID
     * @return 结果
     */
    public int deleteTEmergencyResponseByIds(Long[] responseIds);

    /**
     * 删除应急响应信息
     * 
     * @param responseId 应急响应ID
     * @return 结果
     */
    public int deleteTEmergencyResponseById(Long responseId);
}
