import request from '@/utils/request'

// 查询应急报警通知记录列表
export function listRecord(query) {
  return request({
    url: '/emergency/notify/list',
    method: 'get',
    params: query
  })
}

// 查询应急报警通知记录详细
export function getRecord(id) {
  return request({
    url: '/emergency/notify/' + id,
    method: 'get'
  })
}

// 新增应急报警通知记录
export function addRecord(data) {
  return request({
    url: '/emergency/notify',
    method: 'post',
    data: data
  })
}

// 修改应急报警通知记录
export function updateRecord(data) {
  return request({
    url: '/emergency/notify',
    method: 'put',
    data: data
  })
}

// 删除应急报警通知记录
export function delRecord(id) {
  return request({
    url: '/emergency/notify/' + id,
    method: 'delete'
  })
}

// 导出应急报警通知记录
export function exportRecord(query) {
  return request({
    url: '/emergency/notify/export',
    method: 'get',
    params: query
  })
}

//通知
export function alarmNotify(query) {
  return request({
    url: '/emergency/notify/alarmNotify',
    method: 'get',
    params: query
  })
}
