import request from '@/utils/request'

// 查询场站巡检执行列表
export function listInspect(query) {
  return request({
    url: '/site/inspect/list',
    method: 'get',
    params: query
  })
}

// 查询场站巡检执行详细
export function getInspect(id) {
  return request({
    url: '/site/inspect/' + id,
    method: 'get'
  })
}

// 新增场站巡检执行
export function addInspect(data) {
  return request({
    url: '/site/inspect',
    method: 'post',
    data: data
  })
}

// 修改场站巡检执行
export function updateInspect(data) {
  return request({
    url: '/site/inspect',
    method: 'put',
    data: data
  })
}

// 删除场站巡检执行
export function delInspect(id) {
  return request({
    url: '/site/inspect/' + id,
    method: 'delete'
  })
}

// 导出场站巡检执行
export function exportInspect(query) {
  return request({
    url: '/site/inspect/export',
    method: 'get',
    params: query
  })
}

/**
 * 场站巡检信息
 * @param query
 */
export function selectSiteStationInspectInfo(query) {
  return request({
    url: '/site/inspect/selectSiteStationInspectInfo',
    method: 'get',
    params: query
  })
}
