import request from '@/utils/request'

// 查询地区县镇列表
export function listArea(query) {
  return request({
    url: '/system/area/list',
    method: 'get',
    params: query
  })
}

//获取所有地区信息
export function aLLAreaListInfo(query) {
  return request({
    url: '/system/area/aLLAreaListInfo',
    method: 'get',
    params: query
  })
}

// 查询地区县镇详细
export function getArea(id) {
  return request({
    url: '/system/area/' + id,
    method: 'get'
  })
}

// 新增地区县镇
export function addArea(data) {
  return request({
    url: '/system/area',
    method: 'post',
    data: data
  })
}

// 修改地区县镇
export function updateArea(data) {
  return request({
    url: '/system/area',
    method: 'put',
    data: data
  })
}

// 删除地区县镇
export function delArea(id) {
  return request({
    url: '/system/area/' + id,
    method: 'delete'
  })
}

// 导出地区县镇
export function exportArea(query) {
  return request({
    url: '/system/area/export',
    method: 'get',
    params: query
  })
}
