package com.zehong.system.service.impl;

import java.util.List;
import com.zehong.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TUrgentContactsGroupInfoMapper;
import com.zehong.system.domain.TUrgentContactsGroupInfo;
import com.zehong.system.service.ITUrgentContactsGroupInfoService;

/**
 * 应急联系人分组Service业务层处理
 * 
 * @author zehong
 * @date 2024-12-31
 */
@Service
public class TUrgentContactsGroupInfoServiceImpl implements ITUrgentContactsGroupInfoService 
{
    @Autowired
    private TUrgentContactsGroupInfoMapper tUrgentContactsGroupInfoMapper;

    /**
     * 查询应急联系人分组
     * 
     * @param id 应急联系人分组ID
     * @return 应急联系人分组
     */
    @Override
    public TUrgentContactsGroupInfo selectTUrgentContactsGroupInfoById(Long id)
    {
        return tUrgentContactsGroupInfoMapper.selectTUrgentContactsGroupInfoById(id);
    }

    /**
     * 查询应急联系人分组列表
     * 
     * @param tUrgentContactsGroupInfo 应急联系人分组
     * @return 应急联系人分组
     */
    @Override
    public List<TUrgentContactsGroupInfo> selectTUrgentContactsGroupInfoList(TUrgentContactsGroupInfo tUrgentContactsGroupInfo)
    {
        return tUrgentContactsGroupInfoMapper.selectTUrgentContactsGroupInfoList(tUrgentContactsGroupInfo);
    }

    /**
     * 新增应急联系人分组
     * 
     * @param tUrgentContactsGroupInfo 应急联系人分组
     * @return 结果
     */
    @Override
    public int insertTUrgentContactsGroupInfo(TUrgentContactsGroupInfo tUrgentContactsGroupInfo)
    {
        tUrgentContactsGroupInfo.setCreateTime(DateUtils.getNowDate());
        return tUrgentContactsGroupInfoMapper.insertTUrgentContactsGroupInfo(tUrgentContactsGroupInfo);
    }

    /**
     * 修改应急联系人分组
     * 
     * @param tUrgentContactsGroupInfo 应急联系人分组
     * @return 结果
     */
    @Override
    public int updateTUrgentContactsGroupInfo(TUrgentContactsGroupInfo tUrgentContactsGroupInfo)
    {
        tUrgentContactsGroupInfo.setUpdateTime(DateUtils.getNowDate());
        return tUrgentContactsGroupInfoMapper.updateTUrgentContactsGroupInfo(tUrgentContactsGroupInfo);
    }

    /**
     * 批量删除应急联系人分组
     * 
     * @param ids 需要删除的应急联系人分组ID
     * @return 结果
     */
    @Override
    public int deleteTUrgentContactsGroupInfoByIds(Long[] ids)
    {
        return tUrgentContactsGroupInfoMapper.deleteTUrgentContactsGroupInfoByIds(ids);
    }

    /**
     * 删除应急联系人分组信息
     * 
     * @param id 应急联系人分组ID
     * @return 结果
     */
    @Override
    public int deleteTUrgentContactsGroupInfoById(Long id)
    {
        return tUrgentContactsGroupInfoMapper.deleteTUrgentContactsGroupInfoById(id);
    }

    /**
     * 根据组号删除
     * @param groupId 组号
     * @return
     */
    public int deleteTUrgentContactsGroupInfoByGroupId(String groupId){
        return tUrgentContactsGroupInfoMapper.deleteTUrgentContactsGroupInfoByGroupId(groupId);
    }
}
