package com.zehong.system.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TDangerStatusMapper;
import com.zehong.system.domain.TDangerStatus;
import com.zehong.system.service.ITDangerStatusService;

/**
 * 隐患状态记录Service业务层处理
 * 
 * @author zehong
 * @date 2023-12-01
 */
@Service
public class TDangerStatusServiceImpl implements ITDangerStatusService 
{
    @Autowired
    private TDangerStatusMapper tDangerStatusMapper;

    /**
     * 查询隐患状态记录
     * 
     * @param id 隐患状态记录ID
     * @return 隐患状态记录
     */
    @Override
    public TDangerStatus selectTDangerStatusById(Long id)
    {
        return tDangerStatusMapper.selectTDangerStatusById(id);
    }

    /**
     * 查询隐患状态记录列表
     * 
     * @param tDangerStatus 隐患状态记录
     * @return 隐患状态记录
     */
    @Override
    public List<TDangerStatus> selectTDangerStatusList(TDangerStatus tDangerStatus)
    {
        return tDangerStatusMapper.selectTDangerStatusList(tDangerStatus);
    }

    /**
     * 新增隐患状态记录
     * 
     * @param tDangerStatus 隐患状态记录
     * @return 结果
     */
    @Override
    public int insertTDangerStatus(TDangerStatus tDangerStatus)
    {
        return tDangerStatusMapper.insertTDangerStatus(tDangerStatus);
    }

    /**
     * 修改隐患状态记录
     * 
     * @param tDangerStatus 隐患状态记录
     * @return 结果
     */
    @Override
    public int updateTDangerStatus(TDangerStatus tDangerStatus)
    {
        return tDangerStatusMapper.updateTDangerStatus(tDangerStatus);
    }

    /**
     * 批量删除隐患状态记录
     * 
     * @param ids 需要删除的隐患状态记录ID
     * @return 结果
     */
    @Override
    public int deleteTDangerStatusByIds(Long[] ids)
    {
        return tDangerStatusMapper.deleteTDangerStatusByIds(ids);
    }

    /**
     * 删除隐患状态记录信息
     * 
     * @param id 隐患状态记录ID
     * @return 结果
     */
    @Override
    public int deleteTDangerStatusById(Long id)
    {
        return tDangerStatusMapper.deleteTDangerStatusById(id);
    }
}
