package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TDanger;

/**
 * 安检隐患整改Service接口
 * 
 * @author zehong
 * @date 2023-11-09
 */
public interface ITDangerService 
{
    /**
     * 查询安检隐患整改
     * 
     * @param id 安检隐患整改ID
     * @return 安检隐患整改
     */
    public TDanger selectTDangerById(Long id);

    /**
     * 查询安检隐患整改列表
     * 
     * @param tDanger 安检隐患整改
     * @return 安检隐患整改集合
     */
    public List<TDanger> selectTDangerList(TDanger tDanger);

    /**
     * 新增安检隐患整改
     * 
     * @param tDanger 安检隐患整改
     * @return 结果
     */
    public int insertTDanger(TDanger tDanger);

    /**
     * 修改安检隐患整改
     * 
     * @param tDanger 安检隐患整改
     * @return 结果
     */
    public int updateTDanger(TDanger tDanger);

    /**
     * 批量删除安检隐患整改
     * 
     * @param ids 需要删除的安检隐患整改ID
     * @return 结果
     */
    public int deleteTDangerByIds(Long[] ids);

    /**
     * 删除安检隐患整改信息
     * 
     * @param id 安检隐患整改ID
     * @return 结果
     */
    public int deleteTDangerById(Long id);

    /**
     * 游客数据权限设置
     * @param isVisitor 游客是否可访问
     * @param ids 隐患主键
     * @return
     */
    int dangerDataVisitorPermission(String isVisitor,Long[] ids);
}
