package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TEmergencyResponse;

/**
 * 应急响应Mapper接口
 * 
 * @author zehong
 * @date 2024-09-06
 */
public interface TEmergencyResponseMapper 
{
    /**
     * 查询应急响应
     * 
     * @param responseId 应急响应ID
     * @return 应急响应
     */
    public TEmergencyResponse selectTEmergencyResponseById(Long responseId);

    /**
     * 查询应急响应列表
     * 
     * @param tEmergencyResponse 应急响应
     * @return 应急响应集合
     */
    public List<TEmergencyResponse> selectTEmergencyResponseList(TEmergencyResponse tEmergencyResponse);

    /**
     * 新增应急响应
     * 
     * @param tEmergencyResponse 应急响应
     * @return 结果
     */
    public int insertTEmergencyResponse(TEmergencyResponse tEmergencyResponse);

    /**
     * 修改应急响应
     * 
     * @param tEmergencyResponse 应急响应
     * @return 结果
     */
    public int updateTEmergencyResponse(TEmergencyResponse tEmergencyResponse);

    /**
     * 删除应急响应
     * 
     * @param responseId 应急响应ID
     * @return 结果
     */
    public int deleteTEmergencyResponseById(Long responseId);

    /**
     * 批量删除应急响应
     * 
     * @param responseIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTEmergencyResponseByIds(Long[] responseIds);
}
