package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TClockIn;

/**
 * 考勤打卡Mapper接口
 * 
 * @author zehong
 * @date 2023-11-15
 */
public interface TClockInMapper 
{
    /**
     * 查询考勤打卡
     * 
     * @param id 考勤打卡ID
     * @return 考勤打卡
     */
    public TClockIn selectTClockInById(Long id);

    /**
     * 查询考勤打卡列表
     * 
     * @param tClockIn 考勤打卡
     * @return 考勤打卡集合
     */
    public List<TClockIn> selectTClockInList(TClockIn tClockIn);

    /**
     * 新增考勤打卡
     * 
     * @param tClockIn 考勤打卡
     * @return 结果
     */
    public int insertTClockIn(TClockIn tClockIn);

    /**
     * 修改考勤打卡
     * 
     * @param tClockIn 考勤打卡
     * @return 结果
     */
    public int updateTClockIn(TClockIn tClockIn);

    /**
     * 删除考勤打卡
     * 
     * @param id 考勤打卡ID
     * @return 结果
     */
    public int deleteTClockInById(Long id);

    /**
     * 批量删除考勤打卡
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    public int deleteTClockInByIds(Long[] ids);
}
