package com.zehong.system.service.impl;

import java.util.List;
import com.zehong.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TThirdBuildMapper;
import com.zehong.system.domain.TThirdBuild;
import com.zehong.system.service.ITThirdBuildService;

/**
 * 第三方施工Service业务层处理
 * 
 * @author zehong
 * @date 2023-12-22
 */
@Service
public class TThirdBuildServiceImpl implements ITThirdBuildService 
{
    @Autowired
    private TThirdBuildMapper tThirdBuildMapper;

    /**
     * 查询第三方施工
     * 
     * @param id 第三方施工ID
     * @return 第三方施工
     */
    @Override
    public TThirdBuild selectTThirdBuildById(Long id)
    {
        return tThirdBuildMapper.selectTThirdBuildById(id);
    }

    /**
     * 查询第三方施工列表
     * 
     * @param tThirdBuild 第三方施工
     * @return 第三方施工
     */
    @Override
    public List<TThirdBuild> selectTThirdBuildList(TThirdBuild tThirdBuild)
    {
        return tThirdBuildMapper.selectTThirdBuildList(tThirdBuild);
    }

    /**
     * 新增第三方施工
     * 
     * @param tThirdBuild 第三方施工
     * @return 结果
     */
    @Override
    public int insertTThirdBuild(TThirdBuild tThirdBuild)
    {
        tThirdBuild.setCreateTime(DateUtils.getNowDate());
        return tThirdBuildMapper.insertTThirdBuild(tThirdBuild);
    }

    /**
     * 修改第三方施工
     * 
     * @param tThirdBuild 第三方施工
     * @return 结果
     */
    @Override
    public int updateTThirdBuild(TThirdBuild tThirdBuild)
    {
        return tThirdBuildMapper.updateTThirdBuild(tThirdBuild);
    }

    /**
     * 批量删除第三方施工
     * 
     * @param ids 需要删除的第三方施工ID
     * @return 结果
     */
    @Override
    public int deleteTThirdBuildByIds(Long[] ids)
    {
        return tThirdBuildMapper.deleteTThirdBuildByIds(ids);
    }

    /**
     * 删除第三方施工信息
     * 
     * @param id 第三方施工ID
     * @return 结果
     */
    @Override
    public int deleteTThirdBuildById(Long id)
    {
        return tThirdBuildMapper.deleteTThirdBuildById(id);
    }
}
