package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TPipePoint;

/**
 * 管线打卡点Mapper接口
 * 
 * @author zehong
 * @date 2023-11-15
 */
public interface TPipePointMapper 
{
    /**
     * 查询管线打卡点
     * 
     * @param id 管线打卡点ID
     * @return 管线打卡点
     */
    public TPipePoint selectTPipePointById(Long id);

    /**
     * 查询管线打卡点列表
     * 
     * @param tPipePoint 管线打卡点
     * @return 管线打卡点集合
     */
    public List<TPipePoint> selectTPipePointList(TPipePoint tPipePoint);

    /**
     * 获取所有安检点以及所属人
     * @return
     */
    public List<TPipePoint> selectAllpoint(String pipeType);

    /**
     * 新增管线打卡点
     * 
     * @param tPipePoint 管线打卡点
     * @return 结果
     */
    public int insertTPipePoint(TPipePoint tPipePoint);

    /**
     * 修改管线打卡点
     * 
     * @param tPipePoint 管线打卡点
     * @return 结果
     */
    public int updateTPipePoint(TPipePoint tPipePoint);

    /**
     * 删除管线打卡点
     * 
     * @param id 管线打卡点ID
     * @return 结果
     */
    public int deleteTPipePointById(Long id);

    /**
     * 批量删除管线打卡点
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    public int deleteTPipePointByIds(Long[] ids);

    List<TPipePoint> selectPointDetail(String pipeType);
}
