package com.zehong.web.controller.thirdbuild;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TThirdBuildInspect;
import com.zehong.system.service.ITThirdBuildInspectService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 第三方施工执行Controller
 * 
 * @author zehong
 * @date 2023-12-22
 */
@RestController
@RequestMapping("/third/inspect")
public class TThirdBuildInspectController extends BaseController
{
    @Autowired
    private ITThirdBuildInspectService tThirdBuildInspectService;

    /**
     * 查询第三方施工执行列表
     */
    //@PreAuthorize("@ss.hasPermi('third:inspect:list')")
    @GetMapping("/list")
    public TableDataInfo list(TThirdBuildInspect tThirdBuildInspect)
    {
        startPage();
        List<TThirdBuildInspect> list = tThirdBuildInspectService.selectTThirdBuildInspectList(tThirdBuildInspect);
        return getDataTable(list);
    }

    /**
     * 导出第三方施工执行列表
     */
    //@PreAuthorize("@ss.hasPermi('third:inspect:export')")
    @Log(title = "第三方施工执行", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TThirdBuildInspect tThirdBuildInspect)
    {
        List<TThirdBuildInspect> list = tThirdBuildInspectService.selectTThirdBuildInspectList(tThirdBuildInspect);
        ExcelUtil<TThirdBuildInspect> util = new ExcelUtil<TThirdBuildInspect>(TThirdBuildInspect.class);
        return util.exportExcel(list, "第三方施工执行数据");
    }

    /**
     * 获取第三方施工执行详细信息
     */
    //@PreAuthorize("@ss.hasPermi('third:inspect:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(tThirdBuildInspectService.selectTThirdBuildInspectById(id));
    }

    /**
     * 新增第三方施工执行
     */
    //@PreAuthorize("@ss.hasPermi('third:inspect:add')")
    @Log(title = "第三方施工执行", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TThirdBuildInspect tThirdBuildInspect)
    {
        return toAjax(tThirdBuildInspectService.insertTThirdBuildInspect(tThirdBuildInspect));
    }

    /**
     * 修改第三方施工执行
     */
    //@PreAuthorize("@ss.hasPermi('third:inspect:edit')")
    @Log(title = "第三方施工执行", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TThirdBuildInspect tThirdBuildInspect)
    {
        return toAjax(tThirdBuildInspectService.updateTThirdBuildInspect(tThirdBuildInspect));
    }

    /**
     * 删除第三方施工执行
     */
    //@PreAuthorize("@ss.hasPermi('third:inspect:remove')")
    @Log(title = "第三方施工执行", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(tThirdBuildInspectService.deleteTThirdBuildInspectByIds(ids));
    }
}
