package com.zehong.web.controller.devicemanage;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TDeviceTask;
import com.zehong.system.service.ITDeviceTaskService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 设备巡检任务Controller
 * 
 * @author zehong
 * @date 2023-12-11
 */
@RestController
@RequestMapping("/device/task")
public class TDeviceTaskController extends BaseController
{
    @Autowired
    private ITDeviceTaskService tDeviceTaskService;

    /**
     * 查询设备巡检任务列表
     */
    //@PreAuthorize("@ss.hasPermi('device:task:list')")
    @GetMapping("/list")
    public TableDataInfo list(TDeviceTask tDeviceTask)
    {
        startPage();
        List<TDeviceTask> list = tDeviceTaskService.selectTDeviceTaskList(tDeviceTask);
        return getDataTable(list);
    }

    /**
     *  小程序 设备任务列表
     * @param tDeviceTask
     * @return
     */
    @GetMapping("/wxlist")
    public TableDataInfo wxlist(TDeviceTask tDeviceTask)
    {
        startPage();
        List<TDeviceTask> list = tDeviceTaskService.selectTDeviceTaskNum(tDeviceTask);
        return getDataTable(list);
    }
    /**
     * 导出设备巡检任务列表
     */
    ///@PreAuthorize("@ss.hasPermi('device:task:export')")
    @Log(title = "设备巡检任务", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TDeviceTask tDeviceTask)
    {
        List<TDeviceTask> list = tDeviceTaskService.selectTDeviceTaskList(tDeviceTask);
        ExcelUtil<TDeviceTask> util = new ExcelUtil<TDeviceTask>(TDeviceTask.class);
        return util.exportExcel(list, "设备巡检任务数据");
    }

    /**
     * 获取设备巡检任务详细信息
     */
    //@PreAuthorize("@ss.hasPermi('device:task:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(tDeviceTaskService.selectTDeviceTaskById(id));
    }

    /**
     * 新增设备巡检任务
     */
    ///@PreAuthorize("@ss.hasPermi('device:task:add')")
    @Log(title = "设备巡检任务", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TDeviceTask tDeviceTask)
    {
        return toAjax(tDeviceTaskService.insertTDeviceTask(tDeviceTask));
    }

    /**
     * 修改设备巡检任务
     */
    //@PreAuthorize("@ss.hasPermi('device:task:edit')")
    @Log(title = "设备巡检任务", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TDeviceTask tDeviceTask)
    {
        return toAjax(tDeviceTaskService.updateTDeviceTask(tDeviceTask));
    }

    /**
     * 删除设备巡检任务
     */
    //@PreAuthorize("@ss.hasPermi('device:task:remove')")
    @Log(title = "设备巡检任务", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(tDeviceTaskService.deleteTDeviceTaskByIds(ids));
    }
}
